
% Make figures for PAICO reconstructions

%fln='arcatleurafr_r.20950_1950_prxyN.16_29-Jan-2018_12:10:46.mat';
%fln='arcatleurafr_r.24950_1950_prxyN.16_29-Jan-2018_12:23:15.mat';
fln='arcatleurafr_r.21950_1950_prxyN.15_27-Mar-2018_23:21:33.mat';
load(['./results/' fln])


%===================================
% Save mean and compute percentiles
%===================================


% define the output variable
outputf1=['paico_' fln(1:end-13) '.nc'];


% Years
nccreate(outputf1,'time','Dimensions',{'time',length(result.times)});
ncwrite(outputf1,'time',result.times);
ncwriteatt(outputf1,'time','long_name','Years CE (100 year means)');

% Compute percentiles
X_p=prctile(reconEns,[5 50 95],2);   
X_mn=mean(reconEns,2);

nccreate(outputf1,['t_mn'],'Dimensions',{'time',length(result.times)});
ncwrite(outputf1,['t_mn'],X_mn);
ncwriteatt(outputf1,['t_mn'],'long_name',['Temperature reconstruction mean']);
ncwriteatt(outputf1,['t_mn'],'units','degC');

nccreate(outputf1,['t_ens'],'Dimensions',{'time',length(result.times),'ens',Nb});
ncwrite(outputf1,['t_ens'],reconEns);
ncwriteatt(outputf1,['t_ens'],'long_name',['Temperature reconstruction ensembles']);
ncwriteatt(outputf1,['t_ens'],'units','degC');


nccreate(outputf1,['t_pc'],'Dimensions',{'time',length(result.times),'prctl',3});
ncwrite(outputf1,['t_pc'],X_p);
ncwriteatt(outputf1,['t_pc'],'long_name',['Ensemble percentiles: 5th, 50th, 95th']);
ncwriteatt(outputf1,['t_pc'],'units','degC');

eval(['!ncatted -O --glb_att_add author="Nathan Steiger, LDEO Columbia University, Mar 2018" ' outputf1]);


