
%==========================================================================
% THIS IS THE DRIVING SCRIPT FOR SPEI CALCULATIONS
% Nathan Steiger, Apr 2016
%==========================================================================

% LOAD THE PARAMETERS
%spei_params;

syr=1901;eyr=2014;lyrs=length(syr:eyr);
lat=ncread('/d1/nsteiger/climate-data/cru_ts3/cru_ts3.23.1901.2014.pre.dat.nc','lat');
lon=ncread('/d1/nsteiger/climate-data/cru_ts3/cru_ts3.23.1901.2014.pre.dat.nc','lon');

% mm/month
pr_mm_mon=reshape(permute(ncread('/d1/nsteiger/climate-data/cru_ts3/cru_ts3.23.1901.2014.pre.dat.nc','pre'),[2 1 3]),length(lat)*length(lon),12*lyrs)';

% make sure there are no NaN precip values (not really an issue at monthly
% resolution)
%pr(isnan(pr))=0;
% convert precipitation
k1 =1./[31 28 31 30 31 30 31 31 30 31 30 31]; % days in month, nonleap
F=repmat(k1(:),[lyrs 1]);

% convert from mm/mon to mm/day
pr_mm=bsxfun(@times,pr_mm_mon,F);


% mm/day
PET_mm=reshape(permute(ncread('/d1/nsteiger/climate-data/cru_ts3/cru_ts3.23.1901.2014.pet.dat.nc','pet'),[2 1 3]),length(lat)*length(lon),12*lyrs)';

% get land area (PET has missing values along some coastal regions and
% islands)
field=reshape(permute(ncread('/d1/nsteiger/climate-data/cru_ts3/cru_ts3.23.1901.2014.pet.dat.nc','pet'),[2 1 3]),length(lat)*length(lon),12*lyrs);
nan_f=sum(~isnan(field),2);
lndidx=find((nan_f>0)); % get grid cells with any land

%An example of using opendap to read in pr from BCC
%url='http://strega.ldeo.columbia.edu2:81/expert/CMIP5/.byScenario/.past1000/.atmos/.mon/.pr/.bcc-csm1-1/.r1i1p1/.pr/dods';
%pr=dou2ble(ncread(u2rl,'pr'));

%==================
% SPEI
%==================

% Just take land areas
P=pr_mm(:,lndidx);
PET=PET_mm(:,lndidx);

spei_scl=12;%12 best matches PDSI
%spei_scl=15;
disp(['SPEI scale = ' num2str(spei_scl)])
%krnl='g';% gaussian
krnl='e';% decaying exp
disp(['SPEI kernel function = ' krnl])

disp('Computing SPEI...');tic
x_spei=zeros(length(lndidx),lyrs*12);
parfor j=1:length(lndidx)
    x_spei(j,:)=SPEI(P(:,j),PET(:,j),spei_scl,krnl);
end
tmr=toc;
disp(['Time to compute SPEI: ' num2str(tmr/60) ' mins']);

% SPEI VALUES RESHAPED
spei_lndonly=x_spei;
spei_f=NaN(length(lat)*length(lon),lyrs*12);
spei_f(lndidx,:)=spei_lndonly;
spei_f=reshape(spei_f,length(lat),length(lon),lyrs*12);

% SAVE THE DATA
tmstmp=datestr(now);tmstmp=strrep(tmstmp,' ','_'); % remove space


save(['/d1/nsteiger/climate-data/spei/spei_cruts3_scl_' num2str(spei_scl) '_krnl_' krnl '_' tmstmp '.mat'],...
    'spei_f','spei_lndonly','lndidx','lyrs','syr','eyr','lat','lon','-v7.3')
% save everything...
%save([varpth 'pdsi_output_AWC_' num2str(awc_c) '_u2_' u2o '_' tmstmp '.mat'],'-v7.3')
























