
%==========================================================================
% THIS IS THE DRIVING SCRIPT FOR SPEI CALCULATIONS
% Nathan Steiger, Apr 2016
%==========================================================================

addpath('/home/nsteiger/MATLAB/annual-da/')

% LOAD THE PARAMETERS
%spei_params;
tic

% MODEL TYPE
%mdl='echam5';
%mdl='gfdlhist';
%mdl='cesm_lme';enstyp='SSI_VSK_L'; ens='005';disp(['CESM ensemble = ' ens]);
mdl='cesm_lme'; ens='002';disp(['CESM ensemble = ' ens])
%mdl='gfdlesm2m_pi';
%mdl='gfdlesm2g_pi';

disp(['GCM = ' mdl])

% LOAD THE MODEL DATA

disp('Loading data...')

if strcmp(mdl,'echam5')
    varpth='/d3/nsteiger/echam5wiso/';
    
    syr=1871;eyr=2011;lyrs=length(syr:eyr);
    
    load('/d1/nsteiger/climate-data/echam5/e5_latlon.mat')
    
    % land area
    load([varpth 'sftlf_fx_ECHAM5-wiso.mat'])
    
    % radiation (W/m^2)
    trads=reshape(permute(flip(ncread([varpth 'trads_mon_1871_2011.nc'],'trads'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    srads=reshape(permute(flip(ncread([varpth 'srads_mon_1871_2011.nc'],'srads'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % t_emperature (C):
    t_c=reshape(permute(flip(ncread([varpth 't2m_mon_1871_2011.nc'],'temp2'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)'-273.15;
    %t_f = t_c*33.8; % C to  F
    
    % Surface pressure (Pa):
    ps=reshape(permute(flip(ncread([varpth 'ps_mon_1871_2011.nc'],'aps'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Vapor pressure (Pa):
    huss=reshape(permute(flip(squeeze(ncread([varpth 'qsurf_mon_1871_2011.nc'],'q')),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Surface wind (m/s) (CMIP5 output is at 10m)
    u10=reshape(permute(flip(ncread([varpth 'wind10_mon_1871_2011.nc'],'wind10'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % precipitation, will be converted from kg*m^-2*s^-1 to (mm/day):
    pr=reshape(permute(flip(ncread([varpth 'precip_mon_1871_2011.nc'],'precip'),2),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
elseif strcmp(mdl,'gfdlhist')
    
    varpth='/d1/nsteiger/climate-data/gfdl-esm2m-pi/';
    
    syr=1861;eyr=2005;lyrs=length(syr:eyr);
    
    lat=ncread([varpth 'tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'lat');
    lon=ncread([varpth 'tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'lon');
    
    % land area
    sftlf=permute(ncread([varpth 'sftlf_fx_GFDL-ESM2M_historical_r0i0p0.nc'],'sftlf'),[2 1]);
    
    % radiation (W/m^2)
    rsds=reshape(permute(ncread([varpth 'rsds_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'rsds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rsus=reshape(permute(ncread([varpth 'rsus_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'rsus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlds=reshape(permute(ncread([varpth 'rlds_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'rlds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlus=reshape(permute(ncread([varpth 'rlus_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'rlus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % t_emperature (C):
    t_c=reshape(permute(ncread([varpth 'tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'tas'),[2 1 3]),length(lat)*length(lon),12*lyrs)'-273.15;
    %t_f = t_c*33.8; % C to  F
    
    % Surface pressure (Pa):
    ps=reshape(permute(ncread([varpth 'ps_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'ps'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Vapor pressure (Pa):
    huss=reshape(permute(ncread([varpth 'huss_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'huss'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Surface wind (m/s) (CMIP5 output is at 10m)
    u10=reshape(permute(ncread([varpth 'sfcWind_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'sfcWind'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % precipitation, will be converted from kg*m^-2*s^-1 to (mm/day):
    pr=reshape(permute(ncread([varpth 'pr_Amon_GFDL-ESM2M_historical_r1i1p1_186101-200512.nc'],'pr'),[2 1 3]),length(lat)*length(lon),12*lyrs)';

elseif strcmp(mdl,'gfdlesm2g_pi')
    
    varpth='/d1/nsteiger/climate-data/gfdl-esm2g-pi/';
    
    syr=1;eyr=500;lyrs=length(syr:eyr);
    
    lat=ncread([varpth 'tas_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'lat');
    lon=ncread([varpth 'tas_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'lon');
    
    % land area
    %sftlf=permute(ncread([varpth 'sftlf_fx_GFDL-ESM2G_piControl_r0i0p0.nc'],'sftlf'),[2 1]);
    sftlf=permute(ncread('/d1/nsteiger/climate-data/gfdl-esm2m-pi/sftlf_fx_GFDL-ESM2M_piControl_r0i0p0.nc','sftlf'),[2 1]); % using "M" so they have the same points...
    
    % radiation (W/m^2)
    rsds=reshape(permute(ncread([varpth 'rsds_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'rsds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rsus=reshape(permute(ncread([varpth 'rsus_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'rsus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlds=reshape(permute(ncread([varpth 'rlds_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'rlds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlus=reshape(permute(ncread([varpth 'rlus_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'rlus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % t_emperature (C):
    t_c=reshape(permute(ncread([varpth 'tas_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'tas'),[2 1 3]),length(lat)*length(lon),12*lyrs)'-273.15;
    %t_f = t_c*33.8; % C to  F
    
    % Surface pressure (Pa):
    ps=reshape(permute(ncread([varpth 'ps_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'ps'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Vapor pressure (Pa):
    huss=reshape(permute(ncread([varpth 'huss_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'huss'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Surface wind (m/s) (CMIP5 output is at 10m)
    u10=reshape(permute(ncread([varpth 'sfcWind_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'sfcWind'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % precipitation, will be converted from kg*m^-2*s^-1 to (mm/day):
    pr=reshape(permute(ncread([varpth 'pr_Amon_GFDL-ESM2G_piControl_r1i1p1_000101-050012.nc'],'pr'),[2 1 3]),length(lat)*length(lon),12*lyrs)';

elseif strcmp(mdl,'gfdlesm2m_pi')
    
    varpth='/d1/nsteiger/climate-data/gfdl-esm2m-pi/';
    
    syr=1;eyr=500;lyrs=length(syr:eyr);
    
    lat=ncread([varpth 'tas_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'lat');
    lon=ncread([varpth 'tas_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'lon');
    
    % land area
    sftlf=permute(ncread([varpth 'sftlf_fx_GFDL-ESM2M_piControl_r0i0p0.nc'],'sftlf'),[2 1]);
    
    % radiation (W/m^2)
    rsds=reshape(permute(ncread([varpth 'rsds_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'rsds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rsus=reshape(permute(ncread([varpth 'rsus_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'rsus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlds=reshape(permute(ncread([varpth 'rlds_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'rlds'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    rlus=reshape(permute(ncread([varpth 'rlus_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'rlus'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % t_emperature (C):
    t_c=reshape(permute(ncread([varpth 'tas_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'tas'),[2 1 3]),length(lat)*length(lon),12*lyrs)'-273.15;
    %t_f = t_c*33.8; % C to  F
    
    % Surface pressure (Pa):
    ps=reshape(permute(ncread([varpth 'ps_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'ps'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Vapor pressure (Pa):
    huss=reshape(permute(ncread([varpth 'huss_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'huss'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Surface wind (m/s) (CMIP5 output is at 10m)
    u10=reshape(permute(ncread([varpth 'sfcWind_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'sfcWind'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % precipitation, will be converted from kg*m^-2*s^-1 to (mm/day):
    pr=reshape(permute(ncread([varpth 'pr_Amon_GFDL-ESM2M_piControl_r1i1p1_000101-050012.nc'],'pr'),[2 1 3]),length(lat)*length(lon),12*lyrs)';    
    
elseif strcmp(mdl,'cesm_lme')
    
    %ens='008';
    varpth=['/d6/haibo/lme/cam5/BLMTRC5CN/ALLFORCEINGS/' ens];
    ensnm=ens;
    %varpth=['/d6/haibo/lme/cam5/BLMTRC5CN/' enstyp '/' ens];
    %ensnm=[enstyp '.' ens];
    
    syr=850;eyr=1849;lyrs=length(syr:eyr);
    
    lat=ncread([varpth '/TREFHT/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.TREFHT.085001-184912.nc'],'lat');
    lon=ncread([varpth '/TREFHT/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.TREFHT.085001-184912.nc'],'lon');
    
    % land area
    sftlf=100*permute(ncread([varpth '/QSOIL/b.e11.BLMTRC5CN.f19_g16.' ensnm '.clm2.h0.QSOIL.085001-184912.nc'],'landmask'),[2 1]);
    
    % radiation (W/m^2)
    FSNS=reshape(permute(ncread([varpth '/FSNS/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.FSNS.085001-184912.nc'],'FSNS'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    FLNS=reshape(permute(ncread([varpth '/FLNS/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.FLNS.085001-184912.nc'],'FLNS'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
        
    % t_emperature (C):
    Xv_mon=permute(ncread([varpth '/TREFHT/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.TREFHT.085001-184912.nc'],'TREFHT'),[2 1 3])-273.15;
    disp('Bias correcting surface temperature to climatology')
    [X_clim] = load_obsclim('bearth',lat,lon);
    [nt,nn,nm]=size(Xv_mon);
    Xv_mon12=reshape(Xv_mon,nt,nn,12,nm/12);
    Xv_ns=bsxfun(@minus,Xv_mon12,mean(Xv_mon12,4));% remove climatology
    Xv_bc=bsxfun(@plus,Xv_ns,X_clim); % replace climatology
    Xv_mon=reshape(Xv_bc,nt,nn,nm);	
    t_c=reshape(Xv_mon,length(lat)*length(lon),12*lyrs)';
    %t_c=reshape(permute(ncread([varpth '/TREFHT/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.TREFHT.085001-184912.nc'],'TREFHT'),[2 1 3]),length(lat)*length(lon),12*lyrs)'-273.15;
    %t_f = t_c*33.8; % C to  F
    
    % Surface pressure (Pa):
    ps=reshape(permute(ncread([varpth '/PS/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.PS.085001-184912.nc'],'PS'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    
    % Specific humidity (kg/kg):
    huss=reshape(permute(ncread([varpth '/QBOT/b.e11.BLMTRC5CN.f19_g16.' ensnm '.clm2.h0.QBOT.085001-184912.nc'],'QBOT'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    disp('QBOT is only over land...')
    
    % Surface wind (m/s) (CMIP5 output is at 10m)
    u10=reshape(permute(ncread([varpth '/WIND/b.e11.BLMTRC5CN.f19_g16.' ensnm '.clm2.h0.WIND.085001-184912.nc'],'WIND'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    disp('Wind is only over land...')
    
    % precipitation, will be converted from kg*m^-2*s^-1 to (mm/day): NOTE: kg/m^2/s - the same as mm/s
    %pr=reshape(permute(ncread([varpth '/RAIN/b.e11.BLMTRC5CN.f19_g16.' ensnm '.clm2.h0.RAIN.085001-184912.nc'],'RAIN'),[2 1 3]),length(lat)*length(lon),12*lyrs)';
    %disp('Precip is only over land...')
    
    % USE FULL PRECIPITATION VARIABLE AND BIAS CORRECTION 
    Xv_mon1=ncread(['/d1/nsteiger/climate-data/cesm-lme/pr/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.PRECC.085001-184912.nc'],'PRECC');
    Xv_mon2=ncread(['/d1/nsteiger/climate-data/cesm-lme/pr/b.e11.BLMTRC5CN.f19_g16.' ensnm '.cam.h0.PRECL.085001-184912.nc'],'PRECL');
    Xv_mon=Xv_mon1+Xv_mon2; % precip = convective + large scale
    Xv_mon=permute(Xv_mon,[2 1 3]);
    disp('Bias correcting precipitation to climatology')
    [X_clim] = load_obsclim('gpcp',lat,lon);
    [nt,nn,nm]=size(Xv_mon);
    % Convert precipitation from m/s to mm/day (1 day = 86400 sec)
    Xv_mon=Xv_mon*86400*1000;
    Xv_mon12=reshape(Xv_mon,nt,nn,12,nm/12);
    Xv_ns=bsxfun(@minus,Xv_mon12,mean(Xv_mon12,4));% remove climatology
    Xv_bc=bsxfun(@plus,Xv_ns,X_clim); % replace climatology
    % Replace zero or less with gamma random numbers with a mean of 0.05, a value much less than error in clim obs.
    %  In distribution plots, this gamma error makes the distributions at small values look very much like
    %  the original model distributions (when it has been converted into the appropriate units)
    smlidx=find(Xv_bc<=0);Xv_bc(smlidx)=gamrnd(1,0.05,length(smlidx),1);
    Xv_mon=reshape(Xv_bc,nt,nn,nm);	
    pr=reshape(Xv_mon,length(lat)*length(lon),12*lyrs)';
    % Convert pr to kg/(m^2*s) = mm/s from mm/day
    pr=pr./86400;


end

%An example of using opendap to read in pr from BCC
%url='http://strega.ldeo.columbia.edu2:81/expert/CMIP5/.byScenario/.past1000/.atmos/.mon/.pr/.bcc-csm1-1/.r1i1p1/.pr/dods';
%pr=dou2ble(ncread(u2rl,'pr'));

%==========================================================================
%==========================================================================
%==========================================================================

disp('Pre-computations...')

% make a year vector for calculations
yr_colm = repmat(syr:eyr,[12 1]);
yr_col=repmat(yr_colm(:),[length(lat)*length(lon),1]);

% get land area
%lndidx=find((sftlf(:)>50)); % get grid cells with < 50% land
lndidx=find((sftlf(:)>0)); % get grid cells with any land
%lndidx=find((sftlf(:)>50)&(nlat>-60)); % & not Antarctica => causes
%problems with the calculation

% make a lat vector for calculations
l1=repmat(repmat(lat,1,length(lon)),[1,1,12*lyrs]);
l2=reshape(l1,length(lat)*length(lon),12*lyrs)';
l2=l2(:,lndidx);
lat_col=l2(:);

nlat=repmat(lat,length(lon),1);
%nlon=reshape(repmat(lon,1,length(lat))',length(lon)*length(lat),1);

% Surface net radiation (W/M^2):
%Not an inherent model output caclulate by taking (rsds-rsus)+(rlds-rlus)
% Radiation balance = SW_net + LW_net = SW_incoming - SW_outgoing + LW_incoming - LW_outgoing
if strcmp(mdl,'gfdlhist')
    netrad=rsds-rsus+rlds-rlus;
elseif strcmp(mdl,'gfdlesm2g_pi')
    netrad=rsds-rsus+rlds-rlus;
elseif strcmp(mdl,'gfdlesm2m_pi')
    netrad=rsds-rsus+rlds-rlus;
elseif strcmp(mdl,'echam5')
    netrad=srads+trads;
elseif strcmp(mdl,'cesm_lme')
    netrad=FSNS-FLNS;
end

% Vapor pressure
vp=huss.*ps./(.622+.378*huss);
%e=huss*ps/(.622+.378*huss)Not generally inherent model output so must be calculated

% Estimate u2m from u10m using wind profile power law (empirical est.); the
% mean wind at 2m based on global observations is ~2 m/s
%u2=u10*(2/10)^0.143;
u2=u10*4.87/log(67.8*10-5.42);

% make sure there are no NaN precip values (not really an issue at monthly
% resolution)
pr(isnan(pr))=0;
% convert precipitation
%k1 =[31 28 31 30 31 30 31 31 30 31 30 31]; % days in month, nonleap
%F=repmat(k1(:),[lyrs 1]);
pr=pr*86400;% convert from kg*m-2*s-1 to mm/day
%pr_inmon=bsxfun(@times,pr,F)*86400*0.03937;% convert from kg*m-2*s-1 to in/mon



%=================
% PET CALCULATION
%=================

% Thornwaite method
%t_f = t_c*33.8; % C to  F
%PET = Thornthwaite_PET(t_f(:),lat_list,count_loc,beg_row_col,lat_col);

% Penman-Monteith method (mm/day)
u2o='gcm'; % 2 m wind from the climate model
%u2o='1ms'; % assume uniform 1 m/s wind at 2 m
if strcmp(u2o,'gcm')
    PET_mm=penmont_PET(t_c,netrad,vp,ps,u2);
elseif strcmp(u2o,'1ms')
    PET_mm=penmont_PET(t_c,netrad,vp,ps,[]);
end

%PET_mm_mon=bsxfun(@times,PET_mm,F);%Convert mm/day to mm/month.
%PET_in=PET_mm_mon*0.03937;%Convert mm/month to inches/month.


%==================
% SPEI
%==================

% Just take land areas
P=pr(:,lndidx);
PET=PET_mm(:,lndidx);

spei_scl=12;%12 best matches PDSI
%spei_scl=15;
disp(['SPEI scale = ' num2str(spei_scl)])
%krnl='g';% gaussian
krnl='e';% decaying exp
disp(['SPEI kernel function = ' krnl])

disp('Computing SPEI...');tic
x_spei=zeros(length(lndidx),lyrs*12);
parfor j=1:length(lndidx)
    x_spei(j,:)=SPEI(P(:,j),PET(:,j),spei_scl,krnl);
end
tmr=toc;
disp(['Time to compute SPEI: ' num2str(tmr/60) ' mins']);

% SPEI VALUES RESHAPED
spei_lndonly=x_spei;
spei_f=NaN(length(lat)*length(lon),lyrs*12);
spei_f(lndidx,:)=spei_lndonly;
spei_f=reshape(spei_f,length(lat),length(lon),lyrs*12);

% SAVE THE DATA
tmstmp=datestr(now);tmstmp=strrep(tmstmp,' ','_'); % remove space

if strcmp(mdl,'cesm_lme')
    varpth='/d1/nsteiger/climate-data/cesm-lme/';
    save([varpth mdl '_' ensnm '_spei_output_scl_' num2str(spei_scl) '_krnl_' krnl '_u2_' u2o '_biascorr_' tmstmp '.mat'],...
    'spei_f','spei_lndonly','lndidx','lyrs','syr','eyr','lat','lon','-v7.3')
else
   save([varpth 'spei_output_scl_' num2str(spei_scl) '_krnl_' krnl '_u2_' u2o '_' tmstmp '.mat'],...
    'spei_f','spei_lndonly','lndidx','lyrs','syr','eyr','lat','lon','-v7.3')
    % save everything...
    %save([varpth 'pdsi_output_AWC_' num2str(awc_c) '_u2_' u2o '_' tmstmp '.mat'],'-v7.3')
end





















