
function [Z]=SPI(P,scale)
%Standardized Precipitation Index
% [Z]=spi(P,scale)
%
% P : Vector of monthly precipitation values
% scale : Time scale over which SPI is computed (e.g., 1,3,12,48 months)
% nseas : number of season (monthly=12)
% Example
% Z=SPI(gamrnd(1,1,1000,1),3,12); 3-monthly scale, 
% Notice that  the rest of the months of the fist year are removed.
% eg. if scale = 3, fist year data, 12 SPI values are not estimated.

nseas=12; % assume it's always monthly data
P=P(:);
erase_yr=ceil(scale/12);

% P setting to scaled dataset
A1=zeros(length(P)-scale+1,scale);
for i=1:scale; A1(:,i)=P(i:length(P)-scale+i); end
XS=sum(A1,2);

% Remove first portion of the record to have whole years
if(scale>1); XS(1:nseas*erase_yr-scale+1)=[]; end

Z=zeros(length(XS),1);
for i=1:nseas
    tind=i:nseas:length(XS);
    Xn=XS(tind);
    [zeroa]=find(Xn==0);
    Xn_nozero=Xn;Xn_nozero(zeroa)=[];
    q=length(zeroa)/length(Xn);
    %Gamma parameter estimation and tranform
    parm=gamfit(Xn_nozero);
    Gam_xs=q+(1-q)*gamcdf(Xn,parm(1),parm(2));
    Z(tind)=norminv(Gam_xs);
end