

varpth='./output-recon/';


efl='spatial_skill_cesm_lme010_r10002000_p996_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_217_swtchbld100_alpha05_04-May-2020_11:56:18.mat';

load([varpth,efl])

% Use lat/lon from CESM for it's variable attributes
% varpth=['/d6/haibo/lme/cam5/BLMTRC5CN/ALLFORCEINGS/' ens];
% lat=ncread([varpth '/TREFHT/b.e11.BLMTRC5CN.f19_g16.' ens '.cam.h0.TREFHT.085001-184912.nc'],'lat');
% ncks -A -v lat,lon b.e11.BLMTRC5CN.f19_g16.010.cam.h0.TREFHT.085001-184912.nc cesm_latlon.nc
inputf='./input-recon/cesm_latlon.nc';



% define the output variable
outputf1=['phyda_skill_' mon_o mon_f '_r.' num2str(r_o) '-' num2str(r_f) '_d.' timestp(1:end-9) '.nc'];

% grab lat/lon from model, put it into the output file
eval(['!ncks -A -v lat,lon ',inputf,' ',outputf1]);

% Years
nccreate(outputf1,'time','Dimensions',{'time',reconYrs});
ncwrite(outputf1,'time',r_o:r_f);
ncwriteatt(outputf1,'time','long_name','Years CE');

if strcmp([mon_o mon_f],'AprMar')
   ncwriteatt(outputf1,'time','units','Annual mean starting from April to the next calendar year March');
elseif strcmp([mon_o mon_f],'DecFeb')
   ncwriteatt(outputf1,'time','units','December-January-February average');
elseif strcmp([mon_o mon_f],'JunAug')
   ncwriteatt(outputf1,'time','units','June-July-August average');
end

% Months
mon_r=r_o:(1/12):(r_f+11/12);

nccreate(outputf1,'tmon','Dimensions',{'tmon',length(mon_r)});
ncwrite(outputf1,'tmon',mon_r);
ncwriteatt(outputf1,'tmon','long_name','Fractional years CE');
ncwriteatt(outputf1,'tmon','units','Monthly mean');



%----------- SPATIAL VARIABLES -----------------



   % Extract the mean and uncertainties

pdsi_rp=permute(reshape(sptlskll.pdsi.rp,length(lat),length(lon)),[2 1]);
pdsi_ce=permute(reshape(sptlskll.pdsi.ce,length(lat),length(lon)),[2 1]);
pdsi_crps=permute(reshape(sptlskll.pdsi.crps,length(lat),length(lon)),[2 1]);
pdsi_crpss=permute(reshape(sptlskll.pdsi.crpss,length(lat),length(lon)),[2 1]);

t2m_rp=permute(reshape(sptlskll.t2m.rp,length(lat),length(lon)),[2 1]);
t2m_ce=permute(reshape(sptlskll.t2m.ce,length(lat),length(lon)),[2 1]);
t2m_crps=permute(reshape(sptlskll.t2m.crps,length(lat),length(lon)),[2 1]);
t2m_crpss=permute(reshape(sptlskll.t2m.crpss,length(lat),length(lon)),[2 1]);


nccreate(outputf1,'pdsi_rp','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'pdsi_rp',pdsi_rp);

nccreate(outputf1,'pdsi_ce','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'pdsi_ce',pdsi_ce);

nccreate(outputf1,'pdsi_crps','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'pdsi_crps',pdsi_crps);

nccreate(outputf1,'pdsi_crpss','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'pdsi_crpss',pdsi_crpss);

nccreate(outputf1,'t2m_rp','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'t2m_rp',t2m_rp);

nccreate(outputf1,'t2m_ce','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'t2m_ce',t2m_ce);

nccreate(outputf1,'t2m_crps','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'t2m_crps',t2m_crps);

nccreate(outputf1,'t2m_crpss','Dimensions',{'lon',length(xmeta{k}.lon),'lat',length(xmeta{k}.lat)});
ncwrite(outputf1,'t2m_crpss',t2m_crpss);





