% PLOT PROXY AVAILABILITY

clear

load('distinct_colors_20.mat')

%load(['./proxy-data/LMR_NCDC_database_v.0.2.0/lmr2k_proxydata_aprmar_v0.2.0.mat'])

%efl='cesm_lme010_r10002000_p998_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_148_swtchbld100_psmAlpha05_EurasiaGreen_27-Apr-2020_13:58:46.mat';
efl='cesm_lme010_r10002000_p996_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_217_swtchbld100_alpha05_04-May-2020_11:56:18.mat';

pth='./output-recon/'; load([pth,efl],'proxy')



tlat=[];tlon=[];td=[];j=1;
slat=[];slon=[];sd=[];k=1;
clat=[];clon=[];cd=[];m=1;
ilat=[];ilon=[];id=[];n=1;
pdata=[];
for i=1:length(proxy)

   if ismember(proxy{i}.ptype,{'tree','Tree Rings'})
      tlat(j)=proxy{i}.location(1);
      tlon(j)=proxy{i}.location(2);
      td(j,:)=proxy{i}.data;
      j=j+1;
   elseif ismember(proxy{i}.ptype,{'coral','sclerosponge','Corals and Sclerosponges','Bivalve'})
      clat(k)=proxy{i}.location(1);
      clon(k)=proxy{i}.location(2);
      cd(k,:)=proxy{i}.data;
      k=k+1;
   elseif ismember(proxy{i}.ptype,{'Ice Cores'})
      ilat(m)=proxy{i}.location(1);
      ilon(m)=proxy{i}.location(2);
      id(m,:)=proxy{i}.data;
      m=m+1;
   elseif ismember(proxy{i}.ptype,{'Speleothems'})
      slat(n)=proxy{i}.location(1);
      slon(n)=proxy{i}.location(2);
      sd(n,:)=proxy{i}.data;
      n=n+1;
   end

% put all proxy data into a matrix
pdata(i,:)=proxy{i}.data;
end

% proxy availability by type
avl_t=sum(~isnan(td),1);
avl_c=sum(~isnan(cd),1);
avl_i=sum(~isnan(id),1);
avl_s=sum(~isnan(sd),1);

yrs=(1:2012)';

% remove lone wrong tree
tlon(78)=[];
tlat(78)=[];

%error('Stop')

%Y=cat(2,avl_t,avl_c,avl_i,avl_o);
%X=repmat(year,[4 1])';Y=cat(2,avl_o,avl_i,avl_c,avl_t);
%X=repmat(yrs',[4 1])';Y=cat(1,avl_s,avl_i,avl_c,avl_t)';
X=repmat(yrs',[2 1])';Y=cat(1,avl_i,avl_t)';

figure
h=area(X,Y);
%h(3).FaceColor=[0.4667    0.6745    0.1882];
%h(2).FaceColor=[0.8510    0.3255    0.0980]; 
%h(1).FaceColor=[0.4941    0.1843    0.5569]; 

%h(4).FaceColor=clrs.brown;
%h(3).FaceColor=clrs.navy;
h(2).FaceColor=clrs.brown; 
h(1).FaceColor=clrs.teal; 
xlim([1000 2000])
%xlim([1600 2005])
%legend('Trees','Corals','Ice','Other','location','northwest')
%legend('Other','Ice','Corals','Trees','location','north')
%legend([h(4),h(3),h(2),h(1)],{'Tree-rings','Corals','Ice Cores','Speleothems'},'location','north')
legend([h(2),h(1)],{'Tree-rings','Ice Cores'},'location','north')
xlabel('Year','fontsize',14)
ylabel('Proxy availability','fontsize',14)
ax1=gca;
ax1.YAxisLocation='right';
set(ax1,'XMinorTick','on','YMinorTick','on','fontsize',14)
box on
fig = gcf;fig.PaperUnits = 'inches';
fig.PaperPosition = [0.1 2 8 4]; % [left bottom width height]

%print('./figs/proxy_temporal_avail_phydadjf.pdf','-dpdf','-painters')
print('/home/nsteiger/Dropbox/phyda-djf/proxy_temporal_avail_phydadjf_eurasia.pdf','-dpdf','-painters')


% spatial plot
s=load('coast');
mlat=s.lat;
mlon=s.long;

figure
hold on
axesm('MapProjection','eqdcylin','maplatlimit',[27,90],'maplonlimit',[285 -170]);
title('Proxy Locations','fontsize',18)
%title('PAGES2k-based Pseudoproxy Locations','fontsize',18)
plotm(mlat,mlon,'color',[0.5 0.5 0.5])
h1=plotm(tlat,tlon,'s','color',clrs.brown); % obs locations
%h2=plotm(clat,clon,'*','color',clrs.navy); % obs locations
h3=plotm(ilat,ilon,'o','color',clrs.teal); % obs locations
%h4=plotm(slat,slon,'^','color',clrs.maroon); % obs locations
%h3=plotm(ilat,ilon,'^','color',[0    0.4471    0.7412]);

tightmap

% Plot drought boxed areas
% North American southwest
%linem([25; 25; 42.5; 42.5; 25],[360-125; 360-105; 360-105; 360-125; 360-125],...
%    '-','color',[0 0.4471 0.7412],'linewidth',2)
% East Africa
%linem([-20; -20; 20; 20; -20],[28; 52; 52; 28; 28],...
%    '-','color',[0.4941 0.1843 0.5569],'linewidth',2)


hold off
%legend([h1,h2,h3,h4],{'Tree','Coral','Ice','Other'})
%legend([h1,h2],{'Tree-Ring Records','Coral Records'},'location','southeast')
%legend([h1,h2,h3,h4],{'Tree-rings','Corals','Ice Cores','Speleothems'},'location','southoutside','orientation','horizontal')
legend([h1,h3],{'Tree-rings','Ice Cores'},'location','southoutside','orientation','horizontal')

%print('./figs/proxy_spatial_avail_phydadjf.pdf','-dpdf','-painters')
print('/home/nsteiger/Dropbox/phyda-djf/proxy_spatial_avail_phydadjf_eurasia.pdf','-dpdf','-painters')
























