function plot_line_verif(y_rec,x_rec,y_sig,xb_rec,y_obs,ttl,xlbl,ylbl,prntfg,prntpth,prntnm,cohyn,cohdt,lgndlc)
% Plot the verification figures given appropriate inputs
%
%  y_rec = reconstruction
%  x_rec = time of reconstruction
%  x_sig = 1 std of reconstruction
%  xb_rec = prior estimate of reconstruction (for CRPSS)
%  y_obs = observations
%  ttl = title of plot
%  xlbl = xlabel name
%  ylbl = ylabel name
%  prntfg = print figure [y/n]
%  cohyn = make coherence figure? [y/n]
%  cohdt = time step of coherence
%  lgndlc = location of legend

addpath(genpath('boundedline-pkg/'))
load('./colormaps/distinct_colors_20.mat')


%============================
%  TIME SERIES VERIFICATION
%============================

% compute correlation and CE
rp=nancorr(y_rec,y_obs);
cet=nan_ce(y_obs,y_rec);

% compute mean crpss
frcst_c=crps_m(y_rec,y_sig,y_obs);

% Randomly draw from prior to get a mean CRPS
ref_c0=zeros(500,1);
for i=1:length(ref_c0)    
   rsxb=randsample(xb_rec,length(y_obs));
   ref_c0(i)=crps_m(rsxb,std(rsxb),y_obs);
end
ref_c=mean(ref_c0);
% compute skill score
m_crpss=1-frcst_c/ref_c;

figure
hold on
[hl,hp]=boundedline(x_rec,y_rec,2*y_sig,'cmap',clrs.red);
hl.LineWidth=2;
xt=plot(x_rec,y_obs,'k','linewidth',2);
xlim([x_rec(1),x_rec(end)])
legend([xt,hl,hp],{'Obs.','Recon.','\pm 2 \sigma'},'location',lgndlc)
title(ttl,'fontsize',24,'Interpreter', 'none')
%text(0.05,0.05,['r = ' sprintf('%0.2f',rp) ', CE = ' sprintf('%0.2f',cet)...
%    ', CRPSS = ' sprintf('%0.2f',m_crpss)],'units','normalized','fontsize',14)
text(0.05,0.05,['r = ' sprintf('%0.2f',rp) ...
  ', CRPSS = ' sprintf('%0.2f',m_crpss)],'units','normalized','fontsize',18)
xlabel(xlbl,'fontsize',22)
ylabel(ylbl,'fontsize',22)
set(gca,'fontsize',18)
hold off
box on

if prntfg=='y';print([prntpth 'tm_srs_' prntnm '.png'],'-dpng');end


%=============
%  COHERENCE
%=============
if cohyn=='y'

   % [s, c, ph, ci, phi] = cmtm(x,y,dt,NW,qbias,confn,qplot);
   [f,coh,~,ci,~] = cmtm(y_rec,y_obs,cohdt,8,0,0,0);

   % Print out representative values
   disp(['Var = ' ttl])
   disp(['Coh 2.5 yrs = ' num2str(coh(find(abs(1./f-2.5)<1e-3)))])
   disp(['Coh 5 yrs = ' num2str(coh(find(abs(1./f-5)<1e-3)))])
   disp(['Coh 10 yrs = ' num2str(coh(find(abs(1./f-10)<1e-3)))])


   figure
   hold on
   plot(f,coh,'linewidth',2,'color',clrs.red)
   plot(f,ci,'--','linewidth',2,'color',[0.5 0.5 0.5])
   %plot(f,coh,'linewidth',2,'color',[0.4940 0.1840 0.5560])
   %plot(f,ci,'--','linewidth',2,'color',[0.5 0.5 0.5])
   legend('C(Obs.,Recon.)','95% conf.','location','southwest')
   xlim([0 0.5])
   ylim([0 1])
   set(gca,'XTick',[0 0.1 0.2 0.3 0.4 0.5])
   set(gca,'XTickLabel',{'0','0.1 [10]','0.2 [5]','0.3 [3.3]','0.4 [2.5]','0.5 [2]'})
   box on
   title([ttl ' coherence'],'fontsize',24,'Interpreter', 'none')
   xlabel('Frequency (1/yrs), Period [yrs]','fontsize',22)
   ylabel('Coherence','fontsize',22)
   set(gca,'fontsize',18)
   hold off

   if prntfg=='y';print([prntpth 'coh_' prntnm '.png'],'-dpng');end

end









