function [r,p] = nancorrcoef( X,Y )
% NANCORRCOEF calculates the sample correlation coefficient
%    for the series with NaNs expected.
%    X is the one series, Y is another.
%
%    Mods: return p-value
%    Nathan Steiger, LDEO, Columbia University
%    Wed Apr 22 11:09:16 EDT 2020

X=X(:);
Y=Y(:);
L1=length(X);
L2=length(Y);

if L1 ~= L2
    error('The samples must be of the same length')
end

% Put NaNs in both vectors
for i=1:L1,
    if isnan(X(i)),
        Y(i)=NaN;
    end
    if isnan(Y(i)),
        X(i)=NaN;
    end
end
        
% Remove NaNs
nids=find(isnan(X));
X(nids)=[];
Y(nids)=[];

% Compute correlation with p-values
[r,p]=corr(X,Y);

%Xm=nanmean(X);
%Ym=nanmean(Y);
%C=nansum((X-Xm).*(Y-Ym))/sqrt((nansum((X-Xm).^2))*(nansum((Y-Ym).^2)));

end
