function [CE] = nan_ce(X,Y)
% NAN_CE Calculates the coefficient of efficiency given two vectors while also
% accounting for NaNs that are present.
%   function [CE] = nan_ce(X,Y)
%       where X is the true time series and Y is the reconstructed time
%       series and CE is the coefficient of efficiency
X=X(:);
Y=Y(:);
L1=length(X);
L2=length(Y);
if L1 ~= L2
    error('X & Y must be of the same length')
end
for i=1:L1,
    if isnan(X(i))
        Y(i)=NaN;
    end
    if isnan(Y(i))
        X(i)=NaN;
    end
end
% CE statistic
CE=1-nansum((X-Y).^2)/nansum((X-nanmean(X)).^2);
end

