function [CE] = nanCEv2(X,Y,vidx)
% NANCEV2 Calculates the coefficient of efficiency given two vectors while also
% accounting for NaNs that are present. This version computes the traditional
% CE that knows about a verification period mean being distinct from the mean
% of the whole time series.
%   function [CE] = nan_ce(X,Y,vidx)
%       where X is the true time series and Y is the reconstructed time
%       series and CE is the coefficient of efficiency. 'vidx' are the indices
%       of the vector that correspond to a verification period (no calib.).
%
% N.J. Steiger; mods 7 Dec 2017

X=X(:);
Y=Y(:);
L1=length(X);
L2=length(Y);
if L1 ~= L2
    error('X & Y must be of the same length')
end
for i=1:L1,
    if isnan(X(i))
        Y(i)=NaN;
    end
    if isnan(Y(i))
        X(i)=NaN;
    end
end
% CE statistic
CE=1-nansum((X-Y).^2)/nansum((X-nanmean(X(vidx))).^2);
end

