
% Compute the spatial skill

tic

%addpath('../')

% DJF version of PHYDA with screened proxies
efl='cesm_lme010_r10002000_p996_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_299_swtchbld100_alpha10_06-May-2020_11:38:51.mat';
%efl='cesm_lme010_r10002000_p996_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_134_swtchbld100_alpha02_04-May-2020_14:43:59.mat';
%efl='cesm_lme010_r10002000_p996_state_t2qozn_avg_DecFeb_prxydtst_5_prxtp_tca_217_swtchbld100_alpha05_04-May-2020_11:56:18.mat';

disp(['Loading data: ' efl])

pth='./output-recon/'; load([pth,efl],'-regexp','^(?!Xa_ens)\w')


%varpth=['/d6/haibo/lme/cam5/BLMTRC5CN/ALLFORCEINGS/010'];
%sftlf=permute(ncread([varpth '/QSOIL/b.e11.BLMTRC5CN.f19_g16.010.clm2.h0.QSOIL.085001-184912.nc'],'landmask'),[2 1]);
%lat=ncread([varpth '/QSOIL/b.e11.BLMTRC5CN.f19_g16.010.clm2.h0.QSOIL.085001-184912.nc'],'lat');
%lon=ncread([varpth '/QSOIL/b.e11.BLMTRC5CN.f19_g16.010.clm2.h0.QSOIL.085001-184912.nc'],'lon');

%load(['/d1/nsteiger/climate-data/cesm-lme/cesm_lme_010_pdsi_output_biascorr_AWC_c_7_u2_gcm.mat'],'lndidx')

k=find(state_tp=='q'); % PDSI
Xa_pdsi_lndonly=Xa_m(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:);
lndidx=xmeta{k}.lndidx;
lat=xmeta{k}.lat;lon=xmeta{k}.lon;
Xa_pdsi_f=NaN(length(lat)*length(lon),reconYrs);
Xa_pdsi_f(lndidx,:)=Xa_pdsi_lndonly;
% Additional fields for CRPSS
Xa_pdsi_s=Xa_sigma(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS
Xa_pdsi_sigf=NaN(length(lat)*length(lon),reconYrs);
Xa_pdsi_sigf(lndidx,:)=Xa_pdsi_s;
Xb_pdsi_0=Xb_o(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS
Xb_pdsi=NaN(length(lat)*length(lon),length(p_yrs));
Xb_pdsi(lndidx,:)=Xb_pdsi_0;

% k=find(state_tp=='j'); % SPEI
% Xa_spei_lndonly=Xa_m(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:);
% Xa_spei_f=NaN(length(lat)*length(lon),reconYrs);
% Xa_spei_f(lndidx,:)=Xa_spei_lndonly;
% % Additional fields for CRPSS
% Xa_spei_s=Xa_sigma(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS
% Xa_spei_sigf=NaN(length(lat)*length(lon),reconYrs);
% Xa_spei_sigf(lndidx,:)=Xa_spei_s;
% Xb_spei_0=Xb_o(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS
% Xb_spei=NaN(length(lat)*length(lon),length(p_yrs));
% Xb_spei(lndidx,:)=Xb_spei_0;



k=find(state_tp=='t'); % T2m
Xa_t2m=Xa_m(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:);
% Additional fields for CRPSS
Xa_t2m_sig=Xa_sigma(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS
Xb_t2m=Xb_o(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:); % pull out sigma for CRPSS





% Analysis options
anal_da='n'; % drought atlas verification?
anal_obs='y'; % observational verification?
plot_p='n'; % plot proxies?
make_figs='n'; % Save figures?


if plot_p=='y'
   % Pull out proxy locations
   %plat=nan(length(proxy),1);
   %plon=nan(length(proxy),1);
   j=1;k=1;l=1;
   for i=1:length(proxy)
      if ismember(proxy{i}.ptype,{'tree','Tree Rings'})
	 tlat(j)=proxy{i}.location(1);
	 tlon(j)=proxy{i}.location(2);
	 j=j+1;
      elseif ismember(proxy{i}.ptype,{'coral','sclerosponge','Corals and Sclerosponges','Bivalve'})
	 clat(k)=proxy{i}.location(1);
	 clon(k)=proxy{i}.location(2);
	 k=k+1;
      else % Other proxy type 
	 olat(l)=proxy{i}.location(1);
	 olon(l)=proxy{i}.location(2);
	 l=l+1;
      end 
   end
end

%=========================================
% VERIFICATION AGAINST OBSERVATIONAL DATA
%=========================================

sptlskll=cell(0);

analyrs=1901:2000;

if anal_obs=='y'

   disp('Verifying against PDSI...')
   toc 

   % Load PDSI
   [Xobs,xlat,xlon,x_yrs] = load_obs_S('dai_pdsi',mon_avg_o,mon_avg_f);
   da=reshape(Xobs,length(xlat),length(xlon),length(x_yrs));

   % Interpolate to CESM resolution
   ndm=load('dai_pdsi_mask.mat');
   % create grids for interpolation
   [xn,yn]=meshgrid(xlon,xlat);
   [xc,yc]=meshgrid(lon,lat);
   % note masks of both data types
   nm=find(~isnan(da(:,:,end)));
   cm=find(ndm.sftlf==1);
   da(da<-99)=NaN; % put nans in fill spots but after determining mask

   disp('Interplating obs to climate model res...')
   da_i=nan(length(lat),length(lon),size(da,3));
   for i=1:size(da,3)
      % linear interpolation and extrapolation for irregular data
      da1=da(:,:,i);
      F = scatteredInterpolant(xn(nm),yn(nm),da1(nm),'linear','linear');
      vq=F(xc(cm),yc(cm)); % do the interpolation
      % expand out the interpolated data points onto the climate model mask
      vd=nan(length(lat),length(lon));
      vd(cm)=vq; % full interpolated field
      da_i(:,:,i)=vd;
   end

   % COMPUTE SKILL OF THE RECONSTRUCTION

   [~,~,ir] = intersect(analyrs,r_o:r_f); % indices of recon segment
   [~,~,id] = intersect(analyrs,x_yrs); % indices of DA segment

   dai=reshape(da_i,length(lat)*length(lon),size(da,3));
   rp=zeros(length(lat)*length(lon),1);
   ce=zeros(length(lat)*length(lon),1);
   for j=1:length(lat)*length(lon)
      % Remove mean
      f_mu=Xa_pdsi_f(j,ir)-nanmean(Xa_pdsi_f(j,ir));
      y_o=dai(j,id)-nanmean(dai(j,id));
      rp(j)=nancorr(f_mu,y_o);
      ce(j)=nan_ce(y_o,f_mu);
   end

   disp('Computing CRPSS...')

   % compute mean crpss
   frcst_c=zeros(length(lat)*length(lon),1);
   m_crpss=zeros(length(lat)*length(lon),1);
   for j=1:length(lat)*length(lon)
      % Remove mean
      f_mu=Xa_pdsi_f(j,ir)-nanmean(Xa_pdsi_f(j,ir));
      y_o=dai(j,id)-nanmean(dai(j,id));
      frcst_c(j)=crps_m(f_mu,Xa_pdsi_sigf(j,ir),y_o);
    
      % Randomly draw from prior to get a mean CRPS
      ref_c0=zeros(250,1);
      parfor i=1:length(ref_c0)    
	 rsxb=randsample(Xb_pdsi(j,:),length(y_o));
         rsxb=rsxb-mean(rsxb);
	 ref_c0(i)=crps_m(rsxb,std(rsxb),y_o);
      end
      ref_c=nanmean(ref_c0);

      % compute skill score
      m_crpss(j)=1-frcst_c(j)/ref_c;

   end

   % Save skill maps
   sptlskll.pdsi.rp=rp;
   sptlskll.pdsi.ce=ce;
   sptlskll.pdsi.crps=frcst_c;
   sptlskll.pdsi.crpss=m_crpss;






%    %====================
%    % SPEI VERIFICATION
%    %====================
% 
%    disp('Verifying against SPEI...')
%    toc
% 
%    % Load PDSI
%    [Xobs,xlat,xlon,x_yrs] = load_obs_S('my_spei',mon_avg_o,mon_avg_f);
%    da=reshape(Xobs,length(xlat),length(xlon),length(x_yrs));
% 
%    % Interpolate to CESM resolution
%    ndm=load('dai_pdsi_mask.mat');
%    % create grids for interpolation
%    [xn,yn]=meshgrid(xlon,xlat);
%    [xc,yc]=meshgrid(lon,lat);
%    % note masks of both data types
%    nm=find(~isnan(da(:,:,end)));
%    cm=find(ndm.sftlf==1);
%    da(da<-99)=NaN; % put nans in fill spots but after determining mask
% 
%    disp('Interplating obs to climate model res...')
%    da_i=nan(length(lat),length(lon),size(da,3));
%    for i=1:size(da,3)
%       % linear interpolation and extrapolation for irregular data
%       da1=da(:,:,i);
%       F = scatteredInterpolant(xn(nm),yn(nm),da1(nm),'linear','linear');
%       vq=F(xc(cm),yc(cm)); % do the interpolation
%       % expand out the interpolated data points onto the climate model mask
%       vd=nan(length(lat),length(lon));
%       vd(cm)=vq; % full interpolated field
%       da_i(:,:,i)=vd;
%    end
% 
%    % COMPUTE SKILL OF THE RECONSTRUCTION
% 
%    [~,~,ir] = intersect(analyrs,r_o:r_f); % indices of recon segment
%    [~,~,id] = intersect(analyrs,x_yrs); % indices of DA segment
% 
%    dai=reshape(da_i,length(lat)*length(lon),size(da,3));
%    rp=zeros(length(lat)*length(lon),1);
%    ce=zeros(length(lat)*length(lon),1);
%    for j=1:length(lat)*length(lon)
%       % Remove mean
%       f_mu=Xa_spei_f(j,ir)-nanmean(Xa_spei_f(j,ir));
%       y_o=dai(j,id)-nanmean(dai(j,id));
%       rp(j)=nancorr(f_mu,y_o);
%       ce(j)=nan_ce(y_o,f_mu);
%    end
% 
%    disp('Computing CRPSS...')
% 
%    % compute mean crpss
%    frcst_c=zeros(length(lat)*length(lon),1);
%    m_crpss=zeros(length(lat)*length(lon),1);
%    for j=1:length(lat)*length(lon)
%       % Remove mean
%       f_mu=Xa_spei_f(j,ir)-nanmean(Xa_spei_f(j,ir));
%       y_o=dai(j,id)-nanmean(dai(j,id));
%       frcst_c(j)=crps_m(f_mu,Xa_spei_sigf(j,ir),y_o);
%     
%       % Randomly draw from prior to get a mean CRPS
%       ref_c0=zeros(250,1);
%       parfor i=1:length(ref_c0)    
% 	 rsxb=randsample(Xb_spei(j,:),length(y_o));
%          rsxb=rsxb-mean(rsxb);
% 	 ref_c0(i)=crps_m(rsxb,std(rsxb),y_o);
%       end
%       ref_c=nanmean(ref_c0);
% 
%       % compute skill score
%       m_crpss(j)=1-frcst_c(j)/ref_c;
% 
%    end
% 
%    % Save skill maps
%    sptlskll.spei.rp=rp;
%    sptlskll.spei.ce=ce;
%    sptlskll.spei.crps=frcst_c;
%    sptlskll.spei.crpss=m_crpss;
% 


   %====================
   % T 2m  VERIFICATION
   %====================

   disp('Verifying against T2m...')
   toc

   % Load PDSI
   [Xobs,xlat,xlon,x_yrs] = load_obs_S('bearth',mon_avg_o,mon_avg_f);
   da=reshape(Xobs,length(xlat),length(xlon),length(x_yrs));

   % Interpolate to CESM resolution
   %ndm=load('dai_pdsi_mask.mat');
   % create grids for interpolation
   [xn,yn]=meshgrid(xlon,xlat);
   [xc,yc]=meshgrid(lon,lat);
   % note masks of both data types
   %nm=find(~isnan(da(:,:,end)));
   %cm=find(ndm.sftlf==1);
   %da(da<-99)=NaN; % put nans in fill spots but after determining mask

   disp('Interplating obs to climate model res...')
   da_i=nan(length(lat),length(lon),size(da,3));
   for i=1:size(da,3)
      % linear interpolation and extrapolation for irregular data
      da1=da(:,:,i);
      F = scatteredInterpolant(xn(:),yn(:),da1(:),'linear','linear');
      vq=F(xc,yc); % do the interpolation
      da_i(:,:,i)=vq;
   end

   % COMPUTE SKILL OF THE RECONSTRUCTION

   % get years of overlap
   %[~,ir,ih] = intersect(r_o:r_f,time);
   % Only look at a certain segment of the reconstructions
   %analyrs=1800:1899;
   [~,~,ir] = intersect(analyrs,r_o:r_f); % indices of recon segment
   [~,~,id] = intersect(analyrs,x_yrs); % indices of DA segment

   dai=reshape(da_i,length(lat)*length(lon),size(da,3));
   rp=zeros(length(lat)*length(lon),1);
   ce=zeros(length(lat)*length(lon),1);
   for j=1:length(lat)*length(lon)
      % Remove mean
      f_mu=Xa_t2m(j,ir)-nanmean(Xa_t2m(j,ir));
      y_o=dai(j,id)-nanmean(dai(j,id));
      rp(j)=nancorr(f_mu,y_o);
      ce(j)=nan_ce(y_o,f_mu);
   end

   disp('Computing CRPSS...')

   % compute mean crpss
   frcst_c=zeros(length(lat)*length(lon),1);
   m_crpss=zeros(length(lat)*length(lon),1);
   for j=1:length(lat)*length(lon)
      % Remove mean
      f_mu=Xa_t2m(j,ir)-nanmean(Xa_t2m(j,ir));
      y_o=dai(j,id)-nanmean(dai(j,id));
      frcst_c(j)=crps_m(f_mu,Xa_t2m_sig(j,ir),y_o);
    
      % Randomly draw from prior to get a mean CRPS
      ref_c0=zeros(250,1);
      parfor i=1:length(ref_c0)    
	 rsxb=randsample(Xb_t2m(j,:),length(y_o));
         rsxb=rsxb-mean(rsxb);
	 ref_c0(i)=crps_m(rsxb,std(rsxb),y_o);
      end
      ref_c=nanmean(ref_c0);

      % compute skill score
      m_crpss(j)=1-frcst_c(j)/ref_c;

   end
   % Save skill maps
   sptlskll.t2m.rp=rp;
   sptlskll.t2m.ce=ce;
   sptlskll.t2m.crps=frcst_c;
   sptlskll.t2m.crpss=m_crpss;

end % end analysis of obs


% Save the skill 
save(['./output-recon/spatial_skill_' efl],'-v7.3')





