
% TEST WHETHER OR NOT CHANGING THE VARIANCE OF THE TIME SERIES CAN GIVE SPECTRAL BUMPS

% Make a time series with decreasing variance
x=1:2000;
% generate a red noise time series
y0=ar1_rn([1,2000],0.5,5);
% reduce the variance 
y=y0.*linspace(0.05,1,2000)+2*randn(1,2000);
%y=zscore(y1)*std(y0);


figure;
hold on
%plot(x,y0,'b')
plot(x,y,'r','linewidth',2)
%legend('Original','Var reduced')

%print(['./figs/var_decrease_ex.png'],'-dpng','-r300');

% Compute the spectra
%[p_0,f0,p_0c]=pwelch(detrend(y0),round(length(y0)/8),[],[],1,'ConfidenceLevel',0.9);
[p_o,fo,p_oc]=pwelch(detrend(y(1:end-200)),round(length(y(1:end-200))/8),[],[],1,'ConfidenceLevel',0.9);
[p_1,f1,p_1c]=pwelch(detrend(y(end-200:end)),round(length(y(end-200:end))/8),[],[],1,'ConfidenceLevel',0.9);
figure;hold on;
ho=plot(fo,real(p_o),'linewidth',2,'color','r');
%plot(fo,real(p_oc),'k--');
%h0=plot(f0,real(p_0),'linewidth',2,'color','b');
%plot(f0,real(p_0c),'k--');
h1=plot(f1,real(p_1),'linewidth',2,'color','c');
%plot(f1,real(p_1c),'k--');
xlim([0 0.5]) % limit view to 100 years
ax = gca;
ax.XTick = [0 0.1 0.2 0.3 0.4 0.5];
ax.XTickLabel = {'0','0.1 [10]','0.2 [5]','0.3 [3.3]','0.4 [2.5]','0.5 [2]'};

%legend([ho,h0,h1],{'Var reduced','Original','First seg'})
legend([ho,h1],{'Var reduced','First seg'})


%print(['./figs/var_decrease_ex_spectra.png'],'-dpng','-r300');
