
% Get nino index from temperature field
xatnino=nino(Xt2m,lat,lon,3,'n');

analyrs5=1870:2000;
[~,~,ir5] = intersect(analyrs5,r_o:r_f);

pMap=zeros(length(lat)*length(lon),1);

tMap=zeros(length(lat)*length(lon),1);
for i=1:length(lat)*length(lon)
%   pMap(i)=nancorr(xa_nino_mn_ann(ir5),xp1(i,ir5));
%   tMap(i)=nancorr(xa_nino_mn_ann(ir5),xt1(i,ir5));
   pMap(i)=nancorr(xatnino(ir4),xp1(i,ir4));
   tMap(i)=nancorr(xatnino(ir4),xt1(i,ir4));
%   pMap(i)=nancorr(xatnino(ird_ann),xp1(i,ird_ann));
%   tMap(i)=nancorr(xatnino(ird_ann),xt1(i,ird_ann));
end


s=load('coast');mlat=s.lat;mlon=s.long;

figure;
h=axesm('MapProjection','eqdcylin','MapLatLimit',[(min(lat)) (max(lat))],'MapLonLimit',[min(lon) max(lon)]);
pcolorm(lat,lon,reshape(tMap,length(lat),length(lon)));
%pcolor(reshape(tMap,length(lat),length(lon)))
C=load('./colormaps/NCV_blue_red.mat');
colormap(C.cmap)
caxis([-1 1])
colorbar
plotm(mlat,mlon,'color',[0.5 0.5 0.5])
title('Corr(Nino3.4, T2m A2M), 800-1925')
if prntfg=='y';print(['./figs/corrmap_nino_t2m.png'],'-dpng','-r300'); end
print(['./figs/corrmap_nino_t2m.png'],'-dpng','-r300');


figure;
h=axesm('MapProjection','eqdcylin','MapLatLimit',[(min(lat)) (max(lat))],'MapLonLimit',[min(lon) max(lon)]);
pcolorm(lat,lon,reshape(pMap,length(lat),length(lon)));
%pcolor(reshape(pMap,length(lat),length(lon)))
colormap(C.cmap)
caxis([-1 1])
colorbar
plotm(mlat,mlon,'color',[0.5 0.5 0.5])
title('Corr(Nino3.4, PDSI JJA), 800-1925')
if prntfg=='y';print(['./figs/corrmap_nino_pdsi.png'],'-dpng','-r300'); end
print(['./figs/corrmap_nino_pdsi.png'],'-dpng','-r300');





