
% Different options when computing SOMs


% SA & NA period of analysis
%fln='output_lmr_som16_yrs10011925_22-Nov-2019_12:59:20.mat';
%fln='output_lmr_som12_yrs10011925_22-Nov-2019_12:59:23.mat';
%fln='output_lmr_som8_yrs10011925_22-Nov-2019_13:01:31.mat';
%fln='output_lmr_som6_yrs10011925_22-Nov-2019_13:19:33.mat';
%fln='output_lmr_som20_yrs10011925_22-Nov-2019_13:20:39.mat';

% ENSO regressed out of LMR SSTs
%fln='output_lmr_som20_yrs10011925_02-Dec-2019_11:44:24.mat';
%fln='output_lmr_som16_yrs10011925_02-Dec-2019_11:43:02.mat';
%fln='output_lmr_som12_yrs10011925_02-Dec-2019_11:53:15.mat';
%fln='output_lmr_som8_yrs10011925_02-Dec-2019_11:59:10.mat';
%fln='output_lmr_som6_yrs10011925_02-Dec-2019_11:42:40.mat';

% std(Z500) FOR LMR
%fln='output_lmr_som20_yrs10011925_02-Dec-2019_16:13:30.mat';
%fln='output_lmr_som16_yrs10011925_02-Dec-2019_15:57:06.mat';
%fln='output_lmr_som12_yrs10011925_02-Dec-2019_15:36:05.mat';
%fln='output_lmr_som6_yrs10011925_02-Dec-2019_15:56:08.mat';
%fln='output_lmr_som8_yrs10011925_02-Dec-2019_15:38:03.mat';

% non-standardized Z500 FOR LMR
fln='output_lmr_som20_yrs10011925_02-Dec-2019_16:45:41.mat';
%fln='output_lmr_som16_yrs10011925_02-Dec-2019_16:46:22.mat';
%fln='output_lmr_som12_yrs10011925_02-Dec-2019_17:07:54.mat';
%fln='output_lmr_som8_yrs10011925_02-Dec-2019_17:12:26.mat';
%fln='output_lmr_som6_yrs10011925_02-Dec-2019_17:26:43.mat';


fln0=fln;
%load(['./output_som/' fln])
load([fln])

%---------------------------
%      PLOT PATTERNS
%---------------------------

%inputf='cesm_latlon.nc';
inputf='oceanmask_landmask_lmr.nc';

% define the output variable
outputf=['soms_z500_' fln0(1:end-13) '.nc'];
%outputf=['soms_sst_' fln0(1:end-13) '_noENSO.nc'];
%outputf=['soms_sst_pdsi_' fln0(1:end-13) '_matlabtest.nc'];
%outputf='test_output.nc';inputf='ccsm4_latlon.nc';
% grab lat/lon from model, put it into the output file
eval(['!ncks -A -v lat,lon ',inputf,' ',outputf]);

% PDSI
%efl='cesm_lme010_r12000_p998_state_t2qjozn_avg_JunAug_prxydtst_5_prxtp_tca_2896_swtchbld100_05-Jan-2018_14:49:45.mat';
%efl='cesm_lme010_r12000_p998_state_t2qjozn_avg_DecFeb_prxydtst_5_prxtp_tca_2896_swtchbld100_05-Jan-2018_14:40:23.mat';
%pth='/d2/nsteiger/output-da/hydroclimate/subrecons_5Jan18/';load([pth,efl],'Xa_m','xmeta','state_tp','reconYrs')
%analyrs0=850:1850;
%[~,~,ir0] = intersect(analyrs0,r_o:r_f);

% k=find(state_tp=='q');
% Xvar=Xa_m(xmeta{k}.id_X(1):xmeta{k}.id_X(2),:);
% Xpdsi=NaN(length(xmeta{k}.lat)*length(xmeta{k}.lon),reconYrs);
% Xpdsi(xmeta{k}.lndidx,:)=Xvar;
% Xpdsi=reshape(Xpdsi,length(xmeta{k}.lat),length(xmeta{k}.lon),reconYrs);
% 
% % Detrend data for composites 
% D0=reshape(Xpdsi(:,:,ir0),length(lat)*length(lon),length(ir0));
% dt_pdsi=detrend(D0')';% Detrend the data, if desired

% Add time dimension
nccreate(outputf,'time','Dimensions',{'time',length(analyrs0)});
ncwrite(outputf,'time',analyrs0);
ncwriteatt(outputf,'time','units','Annual mean starting from April to the next calendar year March');
ncwriteatt(outputf,'time','long_name','Years CE');

nccreate(outputf,'bmus','Dimensions',{'time',length(analyrs0)});
ncwrite(outputf,'bmus',bmus);
ncwriteatt(outputf,'bmus','long_name','Best matching units');
ncwriteatt(outputf,'bmus','units','SOM node number');



for i=1:somRows*somCols

   % Get composites of PDSI over the SOMs
%    cind=find(bmus==i);
%    cmp_pdsi=permute(reshape(mean(dt_pdsi(:,cind),2),length(lat),length(lon)),[2 1]);
%    cmp_pdsi(cmp_pdsi==NaN)=1e20;
%    cnm=['cmp_pdsi_' num2str(i)];

   tmp_ptrn=permute(reshape(ptrns(i,:),length(lat),length(lon)),[2 1]);
   tmp_ptrn(tmp_ptrn==NaN)=1e20;
   %pnm=['tmp_ptrn_' num2str(i)];
   pnm=['z500_ptrn_' num2str(i)];
   
%    nccreate(outputf,cnm,'Dimensions',{'lon',length(lon),'lat',length(lat)},'FillValue',1e20);
%    ncwrite(outputf,cnm,cmp_pdsi);
%    ncwriteatt(outputf,cnm,'missing_value',1e20);

   nccreate(outputf,pnm,'Dimensions',{'lon',length(lon),'lat',length(lat)},'FillValue',1e20);
   ncwrite(outputf,pnm,tmp_ptrn);
   ncwriteatt(outputf,pnm,'missing_value',1e20);

end

% Add note about what kind of SOM map it is
eval(['!ncatted -O --glb_att_add note="SOM rows = ' num2str(somRows) ', SOM columns = ' num2str(somCols) '" ' outputf]);
 

 

