
% Make spatial and box plots of the reconstruction skill

%efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_AprMar_prxydtst_5_prxtp_tca_2604_swtchbld100_21-Dec-2017_16:05:26.mat'; seas='A2M';
%efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_DecFeb_prxydtst_5_prxtp_tca_2598_swtchbld100_21-Dec-2017_16:19:04.mat'; seas='DJF';
%efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_JunAug_prxydtst_5_prxtp_tca_2588_swtchbld100_21-Dec-2017_16:30:40.mat'; seas='JJA';

%efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_AprMar_prxydtst_5_prxtp_tca_2896_swtchbld100_05-Jan-2018_14:33:07.mat'; seas='A2M';
%efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_DecFeb_prxydtst_5_prxtp_tca_2896_swtchbld100_05-Jan-2018_14:40:23.mat'; seas='DJF';
efln='spatial_skill_cesm_lme010_r12000_p998_state_t2qjozn_avg_JunAug_prxydtst_5_prxtp_tca_2896_swtchbld100_05-Jan-2018_14:49:45.mat'; seas='JJA';

load(['./output-recon/' efln],'sptlskll','lat','lon','analyrs','fln','proxy')
load('./colormaps/distinct_colors_20.mat')
load('./colormaps/WhiteYellowOrangeRed.mat')

sf={'pdsi','spei','t2m'};
sn={'rp','ce','crps','crpss'};

make_figs='y';
plot_p='n';
plot_sp='y';% make spatial plots?

if plot_p=='y'
   % Pull out proxy locations
   %plat=nan(length(proxy),1);
   %plon=nan(length(proxy),1);
   j=1;k=1;l=1;
   for i=1:length(proxy)
      if ismember(proxy{i}.ptype,{'tree','Tree Rings'})
	 tlat(j)=proxy{i}.location(1);
	 tlon(j)=proxy{i}.location(2);
	 j=j+1;
      elseif ismember(proxy{i}.ptype,{'coral','sclerosponge','Corals and Sclerosponges','Bivalve'})
	 clat(k)=proxy{i}.location(1);
	 clon(k)=proxy{i}.location(2);
	 k=k+1;
      else % Other proxy type 
	 olat(l)=proxy{i}.location(1);
	 olon(l)=proxy{i}.location(2);
	 l=l+1;
      end 
   end
end

if plot_sp=='y'

for i=1:length(sf)

   for j=1:length(sn)
      
      % Extract skill field
      varX=reshape(eval(['sptlskll.' sf{i} '.' sn{j}]),length(lat),length(lon));
      varZ=cat(2,varX,varX(:,1));

      s=load('coast');mlat=s.lat;mlon=s.long;

      figure
      hold on
      %h=axesm('MapProjection','wagner4','MapLatLimit',[(min(xlat)) (max(xlat))],'MapLonLimit',[min(xlon) max(xlon)]);
      h=axesm('MapProjection','eqdcylin','MapLatLimit',[-60 max(lat)]);
      title(['sptlskll ' sf{i} ' ' sn{j} ' ' num2str(analyrs(1)) '-' num2str(analyrs(end))],'fontsize',18,'Interpreter','none')
      pcolorm(lat,[lon; 360],varZ); % add additional value to avoid line in pcolor plots
      plotm(mlat,mlon,'color',[0.5 0.5 0.5])
      if plot_p=='y';
	 h1=plotm(tlat,tlon,'s','color',clrs.green);
	 h2=plotm(clat,clon,'*','color',clrs.purple);
	 h3=plotm(olat,olon,'^','color',clrs.black);
	 %legend([h1,h2,h3],{'Tree-Rings','Corals','Others'},'location','southeast')
      end 
      colormap(cmap) % colormap from 'WhiteYellowOrangeRed'
      set(gca,'fontsize',18)
      %set(get(colorbar('location','southoutside'),'xlabel'),'string',sn{j},'fontsize',14)
      set(get(colorbar('location','southoutside'),'xlabel'),'string','CRPSS','fontsize',18)
      if ~ismember(sn{j},{'CRPS'});
         %caxis([0 1])
	 cmx=0.6;
         caxis([0 cmx])
         cbh = findobj( 0, 'tag', 'Colorbar' ); % and
         %set(cbh,'YTick',[0:0.2:1])
         set(cbh,'YTick',[0:0.1:cmx])
      end
      %set(cbh,'YTick',[-1:0.2:1])
      %delete( cbh )
      hold off

      if  make_figs=='y'
	 print('-dpng',['./figs/sptlskll_' sf{i} '_' sn{j} '_analyrs_' num2str(analyrs(1)) '_' num2str(analyrs(end))...
             '_' fln(1:end-13) '.png',])
      end


   end

end

end

%============================
% Box plot summaries
%============================

varS=NaN(length(lat)*length(lon),length(sf),length(sn));
for i=1:length(sf)
   for j=1:length(sn)
      % Extract skill field
      varS(:,i,j)=eval(['sptlskll.' sf{i} '.' sn{j}]);
   end
end

% Just plot r and CRPSS
% PDSI r; SPEI r; T2m r; PDSI CRPSS; SPEI CRPSS; T2m CRPSS
varSplt=reshape(varS(:,:,[1 4]),length(lat)*length(lon),length(sf)*2);

lbls={'PDSI','SPEI','T2m','PDSI','SPEI','T2m'};
grp={1,2,3,1,2,3};
cgrp=[clrs.blue;clrs.orange;clrs.purple];

figure
%boxplot(varSplt,'colorgroup',grp,'PlotStyle','compact','symbol','','color',cgrp,...
%  'labels',lbls,'labelorientation','horizontal');
boxplot(varSplt,'colorgroup',grp,'symbol','','color',cgrp,...
  'labels',lbls,'labelorientation','horizontal');
set(findobj(gca,'type','line'),'linew',2) % set linewidth thicker
title(seas)
ylabel('Skill','fontsize',28,'fontweight','bold')
ylim([-0.5 0.95])
grid on
ax = gca;ax.XGrid='off';
%set(gca,'fontsize',22,'fontweight','bold')
set(gca,'fontsize',22)
%set(findobj(gca,'Type','text'),'FontSize',18,'VerticalAlignment','top') % labels done differently in boxplot

if make_figs=='y';print(['./figs/skill_boxplot_' seas '.pdf'],'-dpdf');end












