% PLOT PROXY AVAILABILITY

clear

load(['./proxy-data/LMR_NCDC_database_v.0.2.0/lmr2k_proxydata_aprmar_v0.2.0.mat'])
prx_i=lmr2k_data;

load('distinct_colors_20.mat')

% Convert proxy lons into 0 to 360
nlns=find(p_lon<0);
p_lon(nlns)=p_lon(nlns)+360;

prx_im=bsxfun(@minus,prx_i,nanmean(prx_i,1));
prx_d=bsxfun(@rdivide,prx_im,nanstd(prx_im,0,1));

p_idx = find(ismember(archive,{'tree','Tree Rings'}));
tlat=p_lat(p_idx);tlon=p_lon(p_idx);
prxs=prx_d(:,p_idx);
avl_t=sum(~isnan(prxs),2);

p_idx = find(ismember(archive,{'coral','sclerosponge','Corals and Sclerosponges','Bivalve'}));
clat=p_lat(p_idx);clon=p_lon(p_idx);
prxs=prx_d(:,p_idx);
avl_c=sum(~isnan(prxs),2);

% Ice cores
%p_idx = find(ismember(archive,));
%prxs=prx_d(:,p_idx);
%avl_i=sum(~isnan(prxs),2);

p_idx = find(~ismember(archive,{'coral','tree','sclerosponge','marine sediment','Corals and Sclerosponges','Tree Rings','Bivalve'}));
olat=p_lat(p_idx);olon=p_lon(p_idx);
prxs=prx_d(:,p_idx);
avl_o=sum(~isnan(prxs),2);

[~,~,iy1] = intersect(1:2012,year);
yrs=year(iy1)';

%Y=cat(2,avl_t,avl_c,avl_i,avl_o);
%X=repmat(year,[4 1])';Y=cat(2,avl_o,avl_i,avl_c,avl_t);
X=repmat(yrs,[3 1])';Y=cat(2,avl_o,avl_c,avl_t);

figure
h=area(X,Y);
%h(3).FaceColor=[0.4667    0.6745    0.1882];
%h(2).FaceColor=[0.8510    0.3255    0.0980]; 
%h(1).FaceColor=[0.4941    0.1843    0.5569]; 
h(3).FaceColor=clrs.green;
h(2).FaceColor=clrs.navy; 
h(1).FaceColor=clrs.black; 
xlim([0 2005])
%xlim([1600 2005])
%legend('Trees','Corals','Ice','Other','location','northwest')
%legend('Other','Ice','Corals','Trees','location','north')
legend('Other records','Coral records','Tree-ring records','location','north')
xlabel('Year','fontsize',14)
ylabel('Proxy availability','fontsize',14)
ax1=gca;
ax1.YAxisLocation='right';
set(ax1,'XMinorTick','on','YMinorTick','on','fontsize',14)
box on
fig = gcf;fig.PaperUnits = 'inches';
fig.PaperPosition = [0.1 2 8 4]; % [left bottom width height]

%print('./figs/proxy_temporal_avail_LMRdata.pdf','-dpdf','-painters')


% spatial plot
s=load('coast');
mlat=s.lat;
mlon=s.long;

figure
hold on
axesm('MapProjection','eqdcylin');
title('Proxy Locations','fontsize',18)
%title('PAGES2k-based Pseudoproxy Locations','fontsize',18)
plotm(mlat,mlon,'color',[0.5 0.5 0.5])
h1=plotm(tlat,tlon,'s','color',clrs.green); % obs locations
h2=plotm(clat,clon,'*','color',clrs.navy); % obs locations
%h3=plotm(ilat,ilon,'^','color',[0    0.4471    0.7412]);
h4=plotm(olat,olon,'^','color',clrs.black); % obs locations

% Plot drought boxed areas
% North American southwest
%linem([25; 25; 42.5; 42.5; 25],[360-125; 360-105; 360-105; 360-125; 360-125],...
%    '-','color',[0 0.4471 0.7412],'linewidth',2)
% East Africa
%linem([-20; -20; 20; 20; -20],[28; 52; 52; 28; 28],...
%    '-','color',[0.4941 0.1843 0.5569],'linewidth',2)


hold off
%legend([h1,h2,h3,h4],{'Tree','Coral','Ice','Other'})
%legend([h1,h2],{'Tree-Ring Records','Coral Records'},'location','southeast')
legend([h1,h2,h4],{'Tree-ring records','Coral records','Other records'},'location','south','orientation','horizontal')

%print('./figs/proxy_spatial_avail_LMRdata.pdf','-dpdf','-painters')
























