
addpath('/home/nsteiger/MATLAB/hydro-recon/proxy-data/pages2k_noiseproxies/noise-ens')

% File specifications
fmeta = 'metadata_AR-Noise_9_proxy_ama_2.0.0_highres_regional-FDR_screen_infilled.txt';
fdata = 'AR-Noise_9_proxy_ama_2.0.0_highres_regional-FDR_screen_infilled.txt';
%fmeta = 'metadata_2.0.0_highres.txt';
%fdata = 'AR-Noise_9_proxy_ama_2.0.0_calib-selection_1881_1916_1995_0.67_infilled_DINEOF_PAGES-crit-regional+FDR.txt';



%-----------------
% PROXY DATA
%-----------------

% Get the number of columns of the data
delimiter = sprintf('\t','');fid = fopen(fdata,'rt');tLines = fgets(fid);
%numCols = numel(strfind(tLines,delimiter)); % number of columns minus the first year column
numCols = numel(strfind(tLines,delimiter))+1;
fclose(fid);

% Loads data into cell columns
C = textscan(fopen(fdata),repmat('%s',1,numCols),'Delimiter','\t','ReturnOnError',false,'EndOfLine','\r\n');

% Cycle through cell columns to extract the data I want
year=cellfun(@str2num,C{1}(2:end));

% Data matrix: convert strings to double (non-numbers become NaNs)
proxy_ama=NaN(length(C{1})-1,numCols-1);
pnms0=cell(1,numCols-1);
j=1;
for i=2:numCols
   proxy_ama(:,j)=cellfun(@str2double,C{i}(2:end));
   pnms0(j)=C{i}(1);
   j=j+1;
end


%-----------------
% META DATA
%-----------------

% Get the number of columns of the data
delimiter = sprintf('\t','');fid = fopen(fmeta,'rt');tLines = fgets(fid);
%numCols = numel(strfind(tLines,delimiter)); % number of columns minus the first year column
numCols = numel(strfind(tLines,delimiter))+1;
fclose(fid);

% Loads data into cell columns
M = textscan(fopen(fmeta),repmat('%s',1,numCols),'Delimiter','\t','ReturnOnError',false,'EndOfLine','\r\n');

% Extract useful metadata
p_lat0=zeros(1,numCols-1);
p_lon0=zeros(1,numCols-1);
archive0=cell(numCols-1,1);
proxy_names0=cell(1,numCols-1);
j=1;
for i=2:numCols
   archive0(j)=M{i}(4);
   proxy_names0(j)=M{i}(6);
   p_lat0(j)=str2double(M{i}(2));
   p_lon0(j)=str2double(M{i}(3));
   j=j+1;
end

%---------------------------------------------
% Pick out the right metadata only to use it
%---------------------------------------------
[~,~,ir] = intersect(pnms0,proxy_names0,'stable');

proxy_names=proxy_names0(ir);
archive=archive0(ir);
p_lat=p_lat0(ir);
p_lon=p_lon0(ir);















