function [MSE,EVAR,BIAS,BIAS2]= mse(Y,X)
% MSE Computes the mean squared error and it's decomposition: 
%   mse = error variance + bias^2
%
%   [MSE,EVAR,BIAS,BIAS2]= mse(Y,X)
%
%   Y is the truth or reference, X is the estimate and the calculations 
%   assume Y and X are vectors. MSE is the mean squared error, EVAR is the 
%   error variance, BIAS is the bias, and BIAS2 is the bias squared.
%
%   Nathan Steiger

X=X(:);Y=Y(:);
if length(X)~=length(Y);error('Inputs not equal length...');end

m = length(X);
err = X-Y;
BIAS = sum(err)/m; 
BIAS2 = BIAS^2;
EVAR = sum((err-mean(err)).^2)/(m-1);
MSE = sum(err.^2)/m;

end
