%function [T1,T2,M1,M2,MSE,vsl_cr,trw_names,plat,plon,archv_tp]=get_vslite_params(clb_prd);

%--------------------------------------------
% Compute the parameters of the VS-lite code
%--------------------------------------------


addpath('/home/nsteiger/MATLAB/hydro-recon/vs-lite/')

clb_prd=[1901 2000]; 
year=[];

% Load the proxy data

% PAGES2K TEMPERATURE RECONSTRUCTION DATABASE

% proxy_ama_2.0.0_highres.mat % ALL HI-RES PROXIES
load(['/d1/nsteiger/proxy-data/PAGES2k_v2/v2_0_0/proxy_ama_2.0.0_highres.mat'])
disp('Using full-selected PAGES2k temperature proxy data v 2.0.0')

% Raphi's additional network
load(['/home/nsteiger/MATLAB/hydro-recon/pseudoproxies/Trees-non-pages.mat'])
disp('Using Raphis additional proxies...')

% combine both datasets
archive=cat(1,archive,archiveType);
p_lon=cat(1,p_lon(:),longitude);
p_lat=cat(1,p_lat(:),latitude);
proxy_names=cat(1,proxy_names',dataSetName);

% Raphi's data goes from 1000 to 2014 while PAGES goes from 1 to 2012
Rdata=NaN(size(proxy_ama,1),length(dataSetName));
Rdata(1000:2012,:)=data(1:end-2,:);

prx_i=cat(2,proxy_ama,Rdata); % Use Apr-Mar averaged proxies


% Convert proxy lons into 0 to 360
nlns=find(p_lon<0);
p_lon(nlns)=p_lon(nlns)+360;


% standardize proxy data
prx_im=bsxfun(@minus,prx_i,nanmean(prx_i,1));
prx_d=bsxfun(@rdivide,prx_im,nanstd(prx_im,0,1));

% SELECT PROXY DATA
p_idx = find(ismember(archive,{'tree','Tree Rings'})); % 'ice', 'coral', 'documents', 'glacier ice'

prxs=prx_d(:,p_idx);
plat=p_lat(p_idx);
plon=p_lon(p_idx);
pNum=length(p_idx);
archv_tp=archive(p_idx);

trw_names=proxy_names(p_idx);

[T1,T2,M1,M2,~,~,MSE,~,vsl_cr] = tree_vslite_calib(clb_prd,prxs,plat,plon,year,pNum);


save('vsl_hist_params_expanded_9Feb2018.mat')


