function [d]=contig(dyrs,ir1)
% Given droughts in a collection of years, figure out which are contiguous chunks
%
% Nathan Steiger, LDEO July 2019

% NOW FIGURE OUT WHICH YEARS ARE CONTINUOUS CHUNKS
drghts=struct([]); % initialize structure
negpos=ones(length(ir1),1);
negpos(dyrs)=0;
% Find the timing of droughts
i=1;j=1;flag=0;
while i+1 <= length(ir1)
% Find the start of a drought
if negpos(i)==0
   d_start=i;
   i=i+1;
   % Keep going to the end of a drought
   while negpos(i)~=1
       i=i+1;
       if i+1 > length(ir1)
	   d_end=i-1;
	   drghts(j).strtend=[d_start d_end];
	   flag=1;
	   break
       end
   end
   if flag==1;break;end % get out of nested loops
   
   d_end=i-1;
   drghts(j).strtend=[d_start d_end];
   
   j=j+1;
end

i=i+1;
end
   
% Pull out years from structure
d=zeros(length(drghts),2);
for kk=1:length(drghts)
  d(kk,1:2)=drghts(kk).strtend;
end

% Throw out droughts that aren't at least 10 years long
rmv=[];
ii=1;
for jj=1:length(drghts)
   if (d(jj,2)-d(jj,1)) < 10
      rmv(ii)=jj;
      ii=ii+1;
   end
end
d(rmv,:)=[];  


