function X=ar1_rn(sz,a,sf)
% AR1_RN Computes a red noise time series. 
%
% X=ar1_rn(sz,a,sf)
%   Input: 
%       sz = size of time series, vector or matrix [rows,cols], where
%           'rows' are the number of time series, 'cols' are the lengths 
%       a = lag-1 autocorrelation coeffiecient
%       sf = standard deviation scale factor (the std of the noise) column
%           vector
%   Output:
%       X = red noise time series
%
%  Nathan Steiger, April 2013
%

% Intializations
X=zeros(sz);
X(:,1)=sf.*randn(sz(1),1);

for i=2:sz(2)
    X(:,i)=X(:,i-1)*a + sqrt(1-a^2)*sf.*randn(sz(1),1);
end

