function [data_xt]=ann2xt(data_ann,ayrs)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%-------------------------------------------------------------------------%
%                   'ann_to_xt.m', NATHAN STEIGER, MARCH 2013
%-------------------------------------------------------------------------%
%  This function computes any chosen average given annual data.
%-------------------------------------------------------------------------%
% Input:
%   data_ann = annual data of the form (lat,lon,yrs), (locations,yrs), 
%       or a single vector of time series data
%   ayrs = averaging time step
% Output:
%   data_xt = averaged data (lat,lon,xyrs)
%-------------------------------------------------------------------------%



% No averaging 
if ayrs==1
    data_xt=data_ann;
    return
end

% Check data type
num_dims=ndims(data_ann);

if num_dims==2
    
    [x,y]=size(data_ann);
    
    if x==1||y==1
        
        % Number of extraneous years
        nyrs=length(data_ann);
        exyrs=mod(nyrs,ayrs);
        if exyrs~=0
            disp(['ann2xt: Last ' num2str(exyrs) ' yrs discarded...' ])
        end
        
        % Average data
        xyrs=floor(nyrs/ayrs);
        
        j=1;
        k=ayrs;
        data_xt=zeros(xyrs,1);
        for i=1:xyrs
            data_xt(i)=sum(data_ann(j:k))/length(j:k);
            j=j+ayrs;
            k=k+ayrs;
        end
        
    else
        
        % Number of extraneous years
        nyrs=size(data_ann,2);
        exyrs=mod(nyrs,ayrs);
        if exyrs~=0
            disp(['ann2xt: Last ' num2str(exyrs) ' yrs discarded...' ])
        end
        
        % Average data
        xyrs=floor(nyrs/ayrs);
        
        j=1;
        k=ayrs;
        data_xt=zeros(x,xyrs);
        for i=1:xyrs
            data_xt(:,i)=sum(data_ann(:,j:k),2)/length(j:k);
            j=j+ayrs;
            k=k+ayrs;
        end
        
    end
    
elseif num_dims==3
    
    % Number of extraneous years
    [xlat,xlon,nyrs]=size(data_ann);
    exyrs=mod(nyrs,ayrs);
    if exyrs~=0
        disp(['ann2xt: Last ' num2str(exyrs) ' yrs discarded...' ])
    end
    
    % Average data
    xyrs=floor(nyrs/ayrs);
    
    j=1;
    k=ayrs;
    data_xt=zeros(xlat,xlon,xyrs);
    for i=1:xyrs
        data_xt(:,:,i)=sum(data_ann(:,:,j:k),3)/length(j:k);
        j=j+ayrs;
        k=k+ayrs;
    end
    
elseif num_dims>3
    error('Dimensions of monthly data not correct')
end

