function [insol,dayoffset] = seasonal_solar(xi,obl,ecc,long)
% sun code with fix from Aaron Donahoe

% code for insolation from Wen-Wei Pan, based on Berger 
% formulas (JAS, 35, 1978)

%Some parameters
npts=length(xi);
%units of W/m2 and Daily averaged insolation
t1=2808/2.0754;
dr_conv=pi/180;
rd_conv=1/dr_conv;

%work on the conversion from longitude to calendar day
%start by defining the longitude of calendar vernal equinox (in radians)
lmr=0; %the calendar day in radians you want as a reference (0=march21)
beta=(1-ecc^2)^.5;
lm0=lmr-2*((.5*ecc+(1/8)*ecc^3)*((1+beta))*sin(lmr-long*pi/180)-(.25*ecc^2)*(.5+beta)*sin(2*(lmr-long*pi/180))+((1/8)*ecc^3)*((1/3)+beta)*sin(3*(lmr-long*pi/180)));
%above is the corrected longitude of vernal equanox- 
%get the calendar date for other longitudes in the vector of mean longitudes
it=360; %iterations in the mean longitdes
lm=lm0:2*pi/(it):lm0+2*pi-2*pi/it;
calendarlongitude=lm+(2*ecc-.25*ecc^3)*sin(lm-long*pi/180)+(5/4)*(ecc^2)*sin(2*(lm-long*pi/180))+(13/12)*(ecc^3)*sin(3*(lm-long*pi/180));

%adjust so that this falls on zero to 2 pi
for n=1:length(calendarlongitude)
    if calendarlongitude(n)>=2*pi
        calendarlongitude(n)=calendarlongitude(n)-2*pi;
    
    elseif calendarlongitude(n)<0
        calendarlongitude(n)=calendarlongitude(n)+2*pi;
    end
end

lme=[lm lm lm];
calendarlongitudee=[calendarlongitude-2*pi calendarlongitude calendarlongitude+2*pi]; %extend the scheme to cover the domain of interpolation
%now, take a uniform grid of calendar longitudes (time) and find the
%corresponding astronomical longitudes

nts=360;
t=[1:(360-1)/(nts-1):360];

%first the astronomical longitude is 90 degrees offset
tl=(t-90)*pi/180;
for n=1:length(tl)
    if tl(n)<0
        tl(n)=tl(n)+2*pi;
    end
end

astrolon=interp1(calendarlongitudee,lme,tl);


%now convert back to the stupid convention used in this script
astroloni=90+(180/pi)*astrolon;
for n=1:length(astroloni)
    if astroloni(n)>=360
        astroloni(n)=astroloni(n)-360;
    elseif astroloni(n)<0
        astroloni(n)=astroloni+360;
            
    end
end
dayoffset=(astroloni-t)*365/360;

ti=astroloni;





distance = (1-ecc^2)./(1+ecc*cos(dr_conv*(450+ti-long)));
s_delt=-sin(dr_conv*obl)*cos(dr_conv*ti);
c_delt=sqrt(1.0-s_delt.^2);
t_delt = s_delt./c_delt;
delt=asin(s_delt)*rd_conv;

phi = asin(xi)*rd_conv;

wk = zeros(npts,nts);




%loop over latitudes and days to produce insolation
for i = 1:nts
   for j = 1:npts
      if delt(i) > 0.0                     
         if phi(j) >= 90-delt(i)
            wk(j,i)=t1*xi(j)*s_delt(i)/(distance(i)^2);
         elseif ((-phi(j) >= (90 - delt(i))) && (phi(j)<0))
            wk(j,i) = 0;
         else
	    c_h0 = -tan(dr_conv*phi(j))*t_delt(i);
            h0   = acos(c_h0);
            wk(j,i) = t1*(h0*xi(j)*s_delt(i)+cos(dr_conv*phi(j))...
                         *c_delt(i)*sin(h0))...
                          /(distance(i)^2*pi);
         end
      else
	 if phi(j) >= (90 +delt(i))
            wk(j,i)=0;
         elseif (-phi(j)>=(90+delt(i)) && (phi(j)<0))
            wk(j,i)=t1*xi(j)*s_delt(i)/distance(i)^2;
         else
            c_h0=-tan(dr_conv*phi(j))*t_delt(i);
            h0 = acos(c_h0);
            wk(j,i) = t1*(h0*xi(j)*s_delt(i)+cos(dr_conv*phi(j))...
	                 *c_delt(i)*sin(h0))...
                         /(pi*distance(i)^2);
         end
      end
   end
end




% now interpolate onto full resolution array
%insol=interp2(ti,xi,wk,[1:360],x);
insol=wk;
