clear all; 

%clear all;
% Code for Energy Balance Model
% Using old Crank Nicolson algorithm
% Task 1: get it up and running, but with variable longwave coeffs.
% Task2: add in moist static energy diffusion
% Task 3: run it in perturbation mode

% notes- 
% 1. shown that the code can handle a region of B<0 (i.e., locally unstable feedbacks)
% 2. this seems to induce a pretty severe asymmetry in T, might be interesting to explore
% 3. Could look at Forcing, transport, and response anomalies as a 
%    function of latitude

% To do list: 
% - how many iteratsions for convergence in std case? (~20 for delt = 0.1, which seems pretty stable)
% - check units and size of heat capacity
% - understand Mh
% - check the size of the B array
% - calculate diffusion output as practice for calculating m.s.e.

%time step in fraction of year
delt=1./50000; disp(['delt = ' num2str(delt)])
%delt=.1;
NMAX=60000; disp(['NMAX = ' num2str(NMAX)])

%set up x array (latitude).
jmx=101; 
%jmx = 101; disp(['jmx = ' num2str(jmx)])
delx = 2.0/jmx;
x = [-1.0+delx/2:delx:1.0-delx/2]';x = x(:);
phi = asin(x)*180/pi;

% climate parameters
A=203.3; % Size of longwave cooling constant [W/m2]
B=2.09*ones(size(x)); B=B(:); disp('B is constant for control')
% longwave cooling [W/(m2 K)]

%Dmag = 0.44; % magnitude of diffusivity [units?]
Dmag = 0.2598; disp(['D = ' num2str(Dmag) ' W/(m2 K)'])% D = 0.2598 W/(m2 K) is the value used by TF10 
D=Dmag*ones(jmx+1,1); D=D(:); % diffusivity
 
% I think this C = rho * c * h_ml /(pi*1e7).
% this is consistent with a ~1m layer of dirt
% Note - heat capacity over LAND LAND LAND.
%Cl = 0.2; % heat capacity over land. [*check units* J/ (K m^2]
Cl = 0.2; disp(['Cl = ' num2str(Cl) ' J /(m2 K)'])

%Legendre polynomial realizatin of mean annual insol.
%Q = 338.5; %0.25*solar constant [W/m2], small compated to some values
Q = 338.5; disp(['Q = ' num2str(Q) ' W/m2'])
S = Q*(1-0.241*(3*x.^2-1)); S=S(:);

% Moisture parameters
relhum = 0.8;   % relative humidity
eps = 0.622;    % moisture coonstant
psfc = 9.8e4;   % (Pa)
e0 = 611.2;     % vap. press (Pa)
a = 17.67; b = 243.5;   % sat vap constants !!T must be in temperature

L = 2.26e6;         % latent heat of vaporization (J kg-1)
cp = 1004;          % (J kg-1 K-1)



% Use setupfast to create a matrix that calculates D*d/dx[ (1-x^2)d/dx] of
% whatever it operates on.
[~,Mdiv]=setupfastM(delx,jmx,D,0.,1.0,delt);
 
% load in observed climatology in surface temperatures, and symmetrize it
% as the base climatology around which the perturbation
% NOTE: might be interesting to explore the asymmetry (i.e., don't symmetrize)
disp('*************************************************')
disp('*** Perturbation Moist Energy Balance Model ***')
disp('*************************************************')

disp('This calculates the anomalous response to anomalous forcing')
disp('The observed modern climate is used for the background state')
disp('!!This is a terribly written code!!')
disp('It does have a convergence criterion built in,')
disp('but check that Sum = 0 to your satisfaction in the top panel')


load NCEP_ClimoObsTsfc.txt
lat_in = NCEP_ClimoObsTsfc(:,1);
T_in = NCEP_ClimoObsTsfc(:,2);  %import observed T; units K
T_in = 0.5*(T_in+flipud(T_in));

% extrapolate onto the model grid.
T_ctrl = interp1(lat_in,T_in,phi);
T_ctrl = T_ctrl-273.15; % convert to degC (no real reason)

% diagnose q (spec. hum), theta_e, and flux divergence from T_ctrl
q_ctrl = eps*relhum/psfc*e0*exp(a*T_ctrl./(b+T_ctrl)); q_ctrl=q_ctrl(:);% here T is in oC. q is g kg-1
theta_e_ctrl = 1/cp*(cp*(T_ctrl+273.15) + L*q_ctrl);
divF_ctrl = -Mdiv*theta_e_ctrl;

%--------------------------------------------------------------
% Now do climate change experiment
    
disp(['**Doing climate experiment**'])
R_frc = 4.0*ones(size(x)); % uniform forcing in [W/m2]

% x0= 0.0;dx0 = 0.5;
B = 2.09*ones(size(x)); B=B(:);
% B = B - 2.5*exp(-((x-x0)/dx0).^4); disp('B is not constant')

% add some bumps in the feedback profile
x0= 0.9;dx0 = 0.05;
B = B - 3.0.*exp(-((x-x0)/dx0).^4); disp('B is not constant')
B = B - 3.0.*exp(-((x+x0)/dx0).^4); 

x0= 0.25;dx0 = 0.2;
B = B - 1.0*exp(-((x-x0)/dx0).^4); disp('B is not constant')
B = B - 1.0*exp(-((x+x0)/dx0).^4); 
%--------------------------------------------------------------

%set up inital T profile 
T = 0.5*(1-1*x.^2); T = T(:); % this is a parabolic initial profile
Tglob = mean(T); % global mean temperature

%load T_final
Tinit=T;

% Timestepping loop
for n=1:NMAX
   Tglob_prev = Tglob;
       
% Calculate src for this loop.
%   alb=albedo_for_test(T,jmx,x);
   src = R_frc/Cl; src=src(:);
   
% spec. hum, and theta_e
   q = eps*relhum/psfc*e0*exp(a*(T+T_ctrl)./(b+(T+T_ctrl))); q=q(:);% here T is in oC. q is g kg-1
   theta_e = 1/cp*(cp*((T+T_ctrl)+273.15) + L*q); % note units of Kelvin are needed!!!
   theta_e_pert = theta_e-theta_e_ctrl; %anomalous theta_e

% Calculate new T.

% Diffuse sensible heat energy (T)
% Diffusion of T anomaly
%   dT = delt/Cl*(R_frc - (B.*T) + Mdiv*T); if n == 1,disp(['Diffusing T anomaly']),end;

% Diffuse moist static energy (theta_e)
% diffusion of theta_e_anomaly
  dT = delt/Cl*(R_frc - (B.*T) + Mdiv*theta_e_pert); 
  if n == 1, disp(['Diffusing m.s.e. anomaly']), end;

   T = T + dT; 
   
% Check to see if global mean temperature has converged
   Tglob=mean(T);
   Tchange = Tglob-Tglob_prev;
   if (abs(Tchange) < 1.0e-6),disp(['converged! n = ' num2str(n)]); break; end
end


%divF_expt = -Mdiv*T; % use this if you've diffused sensible heat
divF_expt = -Mdiv*theta_e_pert; % use this if you've diffused moist static energy
T_expt = T;

figure(1); clf
subplot(2,1,1)
plot(x,R_frc,'b-','linewidth',2); hold on; grid on
plot(x,divF_expt,'r-','linewidth',2)
plot(x,B.*T_expt,'m-','linewidth',2)
plot(x,R_frc - B.*T_expt - divF_expt,'k-','linewidth',2)
xlabel('Latitude','fontsize',14)
ylabel('Terms (Wm^{-2})','fontsize',14)
title('Check on the solution (sum should be zero)','fontsize',14)
legend('Forcing','Divergence','Feedbacks*T_{local}','Sum',...
    'location','north','orientation','horizontal')

figure(2); clf 
col = 'k';
hold on;
subplot(4,2,1)
plot(x,R_frc,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',12)
ylabel('Forcing (Wm^{-2})','fontsize',12)
xt = [-75 -60 -45 -30 -15 0 15 30 45 60 75];
xt = sind(xt);
xtl = ['-75'; '-60'; '-45'; '-30'; '-15'; '  0'; ' 15'; ' 30'; ' 45'; ' 60';' 75'];
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

hold on;
subplot(4,2,3)
plot(x,-B,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',12)
ylabel('Total feedback (Wm^{-2}K^{-1})','fontsize',12)
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

hold on;
subplot(2,2,2)
plot(x,divF_expt,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',12)
ylabel('\Delta (\nabla \cdot F) (Wm^{-2})','fontsize',12)
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

hold on;
subplot(2,2,3)
plot(x,T_expt,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',12)
ylabel('\Delta T (^oC)','fontsize',12)
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

hold on;
subplot(2,2,4)
plot(x,theta_e_pert*cp,col,'linewidth',2); grid on
xlabel('Latitude')
ylabel('\Delta m.s.e. (J kg^{-1})','fontsize',12)
set(gca,'XTick',xt,'fontsize',12);
set(gca,'XTicklabel',xtl);
