clear all; close all
% Code for Climatological Energy Balance Model
% GHR 13Oct2014. Based on old ebm written by GHR and CMB

% set parameters and display their values
disp('*************************************************')
disp('*** Climatological Moist Energy Balance Model ***')
disp('*************************************************')

disp('This calculates a climatology, for simple albedo feedback')
disp('!!This is a terribly written code!!')
disp('It does have a convergence criterion built in,')
disp('but check that Sum = 0 to your satisfaction in the top panel')
%time step in fraction of year
delt=1./50000; disp(['delt = ' num2str(delt)])
%delt=.1;
NMAX=60000; disp(['NMAX = ' num2str(NMAX)])

%set up x array (latitude).
jmx=151;
%jmx = 101; disp(['jmx = ' num2str(jmx)])
delx = 2.0/jmx;
x = [-1.0+delx/2:delx:1.0-delx/2]';x = x(:);
phi = asin(x)*180/pi;

% climate parameters
A=203.3; % Size of longwave cooling constant [W/m2]
B=2.09*ones(size(x)); B=B(:); disp('B is constant for climatology')
% longwave cooling [W/(m2 K)]

%Dmag = 0.44; % magnitude of diffusivity [units?]
Dmag = 0.2598; disp(['D = ' num2str(Dmag) ' W/(m2 K)'])% D = 0.2598 W/(m2 K) is the value used by TF10
D=Dmag*ones(jmx+1,1); D=D(:); % diffusivity
% simulate hadley cell
% xmp=-1:delx:1;Dmag=0.44;
% D=Dmag*(1+9*exp(-(xmp/sin(25*pi/180)).^6));
% D=D(:);

% I think this C = rho * c * h_ml /(pi*1e7).
% this is consistent with a ~1m layer of dirt
% Note - heat capacity over LAND LAND LAND.
%Cl = 0.2; % heat capacity over land. [*check units* J/ (K m^2]
Cl = 0.2; disp(['Cl = ' num2str(Cl) ' J /(m2 K)'])

%Legendre polynomial realizatin of mean annual insol.
%Q = 338.5; %0.25*solar constant [W/m2], small compated to some values
Q = 338.5; disp(['Q = ' num2str(Q) ' W/m2'])
%S = Q*(1-0.241*(3*x.^2-1)); S=S(:);

% use full solar calculation given orbital inputs
obl=23;ecc=0;scaleQ=1;
[insol] = seasonal_solar(x,obl,ecc,0.);
S=scaleQ*mean(insol,2); S=S(:);

% Moisture parameters
relhum = 0.8;   % relative humidity
eps = 0.622;    % moisture coonstant
psfc = 9.8e4;   % (Pa)
e0 = 611.2;     % vap. press (Pa)
a = 17.67; b = 243.5;   % sat vap constants !!T must be in temperature

L = 2.26e6;         % latent heat of vaporization (J kg-1)
cp = 1004;          % (J kg-1 K-1)


%set up inital T profile
T = 20*(1-2*x.^2); T = T(:);

%load T_final
Tinit=T;

% Use setupfast to create a matrix that calculates D*d/dx[ (1-x^2)d/dx] of
% whatever it operates on.
[~,Mdiv]=setupfastM(delx,jmx,D,0.,1.0,delt);

%Boundary conditions
%Set up initial value for h.
% alb=0.3; disp('No albedo feedback')
albedo_for_mebm_climo(T,jmx,x); disp('Albedo feedback for ctrl')

%Global mean temperature
Tglob=mean(T);

% Timestepping loop
for n=1:NMAX
   Tglob_prev = Tglob;
   
   % Calculate src for this loop.
   alb=albedo_for_mebm_climo(T,jmx,x);
   src=((1-alb).*S-A)/Cl; src=src(:);
   
   % spec. hum, and theta_e
   q = eps*relhum/psfc*e0*exp(a*T./(b+T)); q=q(:);% here T is in oC. q is g kg-1
   theta_e = 1/cp*(cp*(T+273.15) + L*q); % note units of Kelvin are needed!!!
   
   % Calculate new T.
   %   dT = delt/Cl*((1-alb).*S - (A+B.*T) + Mdiv*T); if n == 1,disp(['Diffusing T']),end;
   
   % Diffuse moist static energy (theta_e)
   dT = delt/Cl*((1-alb).*S - (A+B.*T) + Mdiv*theta_e); if n == 1, disp(['Diffusing moist static energy']), end;
   
   T = T + dT;
   
   % Check to see if global mean temperature has converged
   Tglob=mean(T);
   Tchange = Tglob-Tglob_prev;
   if (abs(Tchange) < 1.0e-5), disp(['**Converged n = ' num2str(n)]); break; end
end


% climatological fields
divF_ctrl = -Mdiv*theta_e;
src_ctrl = (1-alb).*S;
T_ctrl = T;
theta_e_ctrl = theta_e;

% graphic check on the energy balance
figure(1); clf
subplot(2,1,1)
plot(x,divF_ctrl,'b-',x,(1-alb).*S,'g-',x,A+B.*T,'r-',...
   x,((1-alb).*S)-(A+B.*T)-(divF_ctrl),'k','linewidth',1.5)

% plot as equal area (sine of latitude)
xt = [-75 -60 -45 -30 -15 0 15 30 45 60 75];
xt = sind(xt);
xtl = ['-75'; '-60'; '-45'; '-30'; '-15'; '  0'; ' 15'; ' 30'; ' 45'; ' 60';' 75'];
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

title('Terms in the energy balance','fontsize',14)
xlabel('latitude','fontsize',14)
ylabel('W m^{-2}','fontsize',14)
h = legend('Transport (\nabla F)','net SW','net OLR','Sum',...
   'location','south', 'orientation','horizontal');
grid on

col = 'k';
hold on;
subplot(2,2,3)
plot(x,T_ctrl,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',14)
ylabel('T (^oC)','fontsize',14)
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);

hold on;
subplot(2,2,4)
plot(x,cp*theta_e_ctrl,col,'linewidth',2); grid on
xlabel('Latitude','fontsize',14)
ylabel('moist static energy (J/kg)','fontsize',14)
set(gca,'XTick',xt);
set(gca,'XTicklabel',xtl);