% D is a function of latitude, not a constant.

% use different numerical scheme at the poles



lat=lat*pi/180;  %make it radius
lat_grid=lat(10)-lat(9);
lat_number=length(lat);

To=200*ones(lat_number,1);  % Temperature at previous time step
%SW=mean(rsdt-rsut-ocean_heat_flux,2);
a=1.93;    % OLR = aT-b; 
%b=295;


del_t=10^-4;  %time step
%D=1.5*10^6;      %Diffusion coefficient. to be defined in "many_EBM2.m"
Cp=1004;   
r=6.378*10^6;   % radius of the earth

Lv=2.5*10^6;  %latent heat
Rd=287;  %gas constant for dry air
Rv=461;  %gas constant for water vapor
g=9.8;
Ps=g*10^4;
Do=Ps*D/g;
Ta=273.16;   % O degree C 
eo=610.78; %saturation vapor pressure at T=0C, 273.15K
hs=0.8;   % surface relative humidity



%diff_mo_p(1:lat_number)=0*lat;
%diff_mo_n(1:lat_number)=0*lat;



A=zeros(lat_number,lat_number);

for k=1:lat_number-1
A(k,k)=-1;
A(k,k+1)=1;
end
%A(lat_number,lat_number)=-1;
%A(lat_number,1)=1;

%A(lat_number,lat_number)=1;
%A(lat_number,lat_number-1)=-1;


B=zeros(lat_number,lat_number);
for k=2:lat_number
    B(k,k)=1;
    B(k,k-1)=-1;
end
%B(1,1)=1;
%B(1,lat_number)=-1;
%B(1,1)=-1;
%B(1,2)=1;

C=1;  %ocean heat capacity


lat_ph=lat+lat_grid/2;
lat_nh=lat-lat_grid/2;




for n=1:1000000
%for n=1:2

es=eo*exp((-Lv/Rv)*(1./To-1/Ta));
mo=Cp*To+Lv*hs*Rd*es/(Rv*Ps);
OLR=a*To-b;  %out going longwave

Diff=Do'.*r^(-2).*(cos(lat)).^(-1).*(lat_grid)^(-2).*(cos(lat_ph).*(A*mo)-cos(lat_nh).*(B*mo));

% for south boundary (first grid point)
Diff(1)=Do(1)*r^(-2)*(cos(lat(1)))^(-1)*(lat_grid)^(-2)*(cos(lat(2))*(mo(3)-mo(2))-cos(lat(1))*(mo(2)-mo(1)));

% for north boundary (last grid point)
Diff(lat_number)=Do(lat_number)*r^(-2)*(cos(lat(lat_number)))^(-1)*(lat_grid)^(-2)*(cos(lat(lat_number))*(mo(lat_number)-mo(lat_number-1))-cos(lat(lat_number-1))*(mo(lat_number-1)-mo(lat_number-2)));

Tn=To+(del_t*(SW-OLR+Diff))/C;



To=Tn;    %updating surface temperature

W=(max(abs(SW-OLR+Diff))<0.001 && n>1);    % break the loop if equilibrium is reached
if W==1
    break;
end




end

n
lat=lat*180/pi;
lat_grid=lat_grid*180/pi;

